package com.rocogz.syy.common.aliyunoss.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 阿里云 SSO 配置
 * @author：liangyongtong
 * @since：2020/3/28
 */
@ConfigurationProperties(prefix = "aliyun.oss.config")
public class AliyunOssProperties {
    /**
     * 用户保存对象的bucket的名称
     */
    private String bucket;
    /**
     * endpoint根据region的实际情况配置(上传端点)
     */
    private String endpoint;

    /**
     * 公网访问端点
     */
    private String visitEndPoint;

    /**
     * 权限认证：AccessKeyId
     */
    private String accessKeyId;
    /**
     * 权限认证：AccessKeySecret
     */
    private String accessKeySecret;

    /**
     * 本地保存临时目录
     */
    private String localTmpDirectory;

    /**
     * 本地保存永久目录
     */
    private String localDirectory;


    public String getBucket() {
        return bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getEndpoint() {
        return endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getVisitEndPoint() {
        return visitEndPoint;
    }

    public void setVisitEndPoint(String visitEndPoint) {
        this.visitEndPoint = visitEndPoint;
    }

    public String getAccessKeyId() {
        return accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public String getLocalTmpDirectory() {
        return localTmpDirectory;
    }

    public void setLocalTmpDirectory(String localTmpDirectory) {
        this.localTmpDirectory = localTmpDirectory;
    }

    public String getLocalDirectory() {
        return localDirectory;
    }

    public void setLocalDirectory(String localDirectory) {
        this.localDirectory = localDirectory;
    }
}
