/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.common.tencent.config;

import com.rocogz.syy.common.tencent.QQMapService;
import com.rocogz.syy.common.tencent.config.QQMapProperties;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={QQMapProperties.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@ConditionalOnProperty(prefix="qq.map", name={"key"})
public class QQMapAutoConfiguration {
    @Autowired
    private QQMapProperties props;

    @ConditionalOnMissingBean
    @Bean
    public RestTemplate restTemplate() {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory((HttpClient)client);
        factory.setReadTimeout(15000);
        factory.setConnectTimeout(15000);
        return new RestTemplate((ClientHttpRequestFactory)factory);
    }

    @Bean
    public QQMapService qqMapService() {
        return new QQMapService(this.props);
    }
}

