package com.rocogz.syy.common.tencent.resp;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.tencent.DistanceTime;
import org.springframework.data.domain.Sort;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.List;

/**
 * 单出发地 -> 多目的的计算返回结果
 * @author zhangmin
 * @date 2020/4/8
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class QQSingleOriginMultiDestDistanceResp extends QQMapBaseResp {

    private List<DistanceTime> result;

    public List<DistanceTime> getResult() {
        return result;
    }

    public void setResult(List<DistanceTime> result) {
        this.result = result;
    }


    /**
     * 按照距离排序
     */
    public void sortByDistance(Sort.Direction sortDirect) {
        if(CollectionUtils.isEmpty(this.result) || sortDirect==null) {
            return;
        }

        Collections.sort(result,(d1, d2)-> {
            if(sortDirect.isAscending()) {
                return d1.getDistance() - d2.getDistance();
            }else {
                return d1.getDistance() - d1.getDistance();
            }
        });

    }
}
