package com.rocogz.syy.common.web;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.util.Collections;
import java.util.List;

/**
 * 解决了 java8中日期转换问题的 json服务
 * @author zhangmin
 * @date 2020/5/28
 */
public final class JsonJava8Util {

    private JsonJava8Util() {
    }


    public static ObjectMapper getObjectMapper() {
        return JacksonCustomizerConverterAutoConfiguration.OBJECT_MAPPER;
    }


    /**
     * @param pojo 或者 pojo 列表,或者 map
     */
    public static String toJson(Object pojo) {
        if(pojo ==null) {
            return null;
        }
        String toJson = StringUtils.EMPTY;
        try {
            toJson = getObjectMapper().writeValueAsString(pojo);
        } catch (JsonProcessingException ex) {
            ex.printStackTrace();
        }
        return toJson;
    }


    public static <T> T fromJson(String json, Class<T> pojoClass) {
        if (StringUtils.isBlank(json)) {
            return null;
        } else {
            try {
                return getObjectMapper().readValue(json, pojoClass);
            } catch (IOException ex) {
                return null;
            }
        }
    }


    /**
     * Json串  转成POJO对象 List,带泛型
     *
     * @param json  json串
     * @param pojoClass 实体类class
     */
    public static <T> List<T> fromJsonAsList(String json, Class<T> pojoClass) {
        if (StringUtils.isBlank(json)) {
            return Collections.emptyList();
        }

        JavaType type = getObjectMapper().getTypeFactory().
                constructCollectionType(List.class, pojoClass);
        try {
            return getObjectMapper().readValue(json, type);
        } catch (IOException e) {
            return Collections.emptyList();
        }
    }

}
