package com.rocogz.syy.common.aliyunoss.config;

import com.rocogz.syy.common.aliyunoss.service.UploadService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.unit.DataSize;

import javax.servlet.MultipartConfigElement;
import java.io.File;

/**
 * 配置上传阿里云
 * @author ：liangyongtong
 * @since ：2020/3/28
 */
@Configuration
@ConditionalOnMissingBean(UploadService.class)
@EnableConfigurationProperties(AliyunOssProperties.class)
@ConditionalOnProperty(prefix = "aliyun.oss.config", name = "isopen", havingValue = "true")
public class AliyunOssConfig {

    @Autowired
    private AliyunOssProperties ssoProperties;

    @Bean
    public UploadService uploadService() {
        return new UploadService(ssoProperties);
    }


    /**
     *设置文件上传的temp文件夹：因为SpringBoot默认临时上传文件夹在N天后不操作，就会被Linux系统自动清理
     *此时就会报：SpringBoot文件上传异常之提示The temporary upload location xxx is not valid
     * 设置上传图片最大值
     */
    @ConditionalOnMissingBean
    @Bean
    public MultipartConfigElement multipartConfigElement() {
        MultipartConfigFactory factory = new MultipartConfigFactory();
        DataSize maxSize = DataSize.ofBytes(50*1024*1024);
        //解决办法如下：
        String projectDirPath = System.getProperty("user.dir");
        String activityUploadTmpDir = projectDirPath+"/uploadTmpDir";
        File uploadTempDir = new File(activityUploadTmpDir);
        if(!uploadTempDir.exists()) {
            uploadTempDir.mkdirs();
        }
        factory.setLocation(activityUploadTmpDir);
        factory.setMaxFileSize(maxSize);
        factory.setMaxRequestSize(maxSize);
        return factory.createMultipartConfig();
    }
}
