package com.rocogz.syy.common.methodaoplog;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 日志
 * @author liangyongtong
 * @since 2020-08-13
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
public @interface RequestLog {
    /**
     * 路径
     * @return
     */
    String apiUrl() default "";

    /**
     * 模块名
     * @return
     */
    String module() default "";

    /**
     * 级别
     * @return
     */
     Level level() default Level.DEBUG;

    /**
     * 日志级别
     */
    enum Level {
        DEBUG, INFO;
    }
}
