package com.rocogz.syy.common.tencent;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 行政区域
 * @author zhangmin
 * @date 2020/4/8
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class DistrictArea {

    private String province;

    private String city;

    private String district;

    private String street;

    /**
     * 门牌号
     */
    @JsonProperty("street_number")
    private String streetNumber;

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getStreet() {
        return street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getStreetNumber() {
        return streetNumber;
    }

    public void setStreetNumber(String streetNumber) {
        this.streetNumber = streetNumber;
    }
}
