package com.rocogz.syy.common.tencent.resp;


import com.fasterxml.jackson.annotation.JsonProperty;
import com.rocogz.syy.common.tencent.DistrictArea;
import com.rocogz.syy.common.tencent.LngLat;

/**
 * Created by zhangmin on 2020/4/08.
 */
public abstract class QQMapBaseResp {

    /**
     * 状态码:
     * 0  为正常
     * 310 请求参数信息有误
     * 311 Key格式错误
     * 306 请求有护持信息请检查字符串
     * 110 请求来源未被授权
     */
    private Integer status;


    /**
     * 状态描述或错误描述信息
     */
    private String message;

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public boolean isSuccess() {
        return status != null && status == 0;
    }


    static class LngLatDistrict {

        /**
         * 经纬度
         */
        private LngLat location;

        /**
         * 行政区域
         */
        protected DistrictArea district;

        protected String address;

        public LngLat getLocation() {
            return location;
        }

        public void setLocation(LngLat location) {
            this.location = location;
        }

        public DistrictArea getDistrict() {
            return district;
        }

        @JsonProperty("address_components")
        public void setDistrict(DistrictArea district) {
            this.district = district;
        }

        public String getAddress() {
            return address;
        }

        public void setAddress(String address) {
            this.address = address;
        }
    }
}
