package com.rocogz.syy.common;

import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration(proxyBeanMethods = false)
public class CommonPoolConfig {


    @ConditionalOnMissingBean
    @Bean
    public RestTemplate restTemplate() {
        HttpClient client = HttpClientBuilder.create().build();
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory(client);

        factory.setReadTimeout(15_000);
        factory.setConnectTimeout(15_000);
        return new RestTemplate(factory);
    }


    /**
     @Bean public ThreadPoolTaskExecutor taskThreadPool() {
     ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
     //此方法返回可用处理器的虚拟机的最大数量; 不小于1
     //int core = Runtime.getRuntime().availableProcessors();
     executor.setCorePoolSize(15);//设置核心线程数
     executor.setMaxPoolSize(30);//设置最大线程数
     executor.setKeepAliveSeconds(60*30);//除核心线程外的线程存活时间
     executor.setQueueCapacity(4000);//如果传入值大于0，底层队列使用的是LinkedBlockingQueue,否则默认使用SynchronousQueue
     executor.setThreadNamePrefix("thread-execute");//线程名称前缀

     executor.initialize();
     executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());//设置拒绝策略
     return executor;
     }
     **/


}
