/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.common.web;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.common.web.JacksonCustomizerConverterAutoConfiguration;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class JsonJava8Util {
    private JsonJava8Util() {
    }

    public static ObjectMapper getObjectMapper() {
        return JacksonCustomizerConverterAutoConfiguration.OBJECT_MAPPER;
    }

    public static String toJson(Object pojo) {
        if (pojo == null) {
            return null;
        }
        String toJson = "";
        try {
            toJson = JsonJava8Util.getObjectMapper().writeValueAsString(pojo);
        }
        catch (JsonProcessingException ex) {
            ex.printStackTrace();
        }
        return toJson;
    }

    public static <T> T fromJson(String json, Class<T> pojoClass) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (T)JsonJava8Util.getObjectMapper().readValue(json, pojoClass);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static <T> T fromJson(String json, TypeReference<T> typeRef) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (T)JsonJava8Util.getObjectMapper().readValue(json, typeRef);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static <T> Response<T> fromJsonToResp(String responseJson, TypeReference<Response<T>> typeRef) {
        if (StringUtils.isBlank((CharSequence)responseJson)) {
            return null;
        }
        try {
            return (Response)JsonJava8Util.getObjectMapper().readValue(responseJson, typeRef);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static <T> List<T> fromJsonAsList(String pojoListJson, Class<T> pojoClass) {
        if (StringUtils.isBlank((CharSequence)pojoListJson)) {
            return Collections.emptyList();
        }
        CollectionType type = JsonJava8Util.getObjectMapper().getTypeFactory().constructCollectionType(List.class, pojoClass);
        try {
            return (List)JsonJava8Util.getObjectMapper().readValue(pojoListJson, (JavaType)type);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }
}

