package com.rocogz.syy.common.methodaoplog;

import com.rocogz.syy.common.web.JsonJava8Util;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

/**
 * 日志处理
 * @author：liangyongtong
 * @since：2020/8/13
 */
@Configuration
@Aspect
public class MethodAopLog {

    private Logger log = LoggerFactory.getLogger(this.getClass());

    /**
     * 处理加了该注解的方法
     */
    @Pointcut(value = "@annotation(com.rocogz.syy.common.methodaoplog.RequestLog)")
    public void pointcutMethod() {}

    /**
     *
     * @param point
     * @param requestLog
     * @return
     * @throws Throwable
     */
    @Around(value = "pointcutMethod() && @annotation(requestLog)", argNames = "requestLog")
    public Object around(ProceedingJoinPoint point, RequestLog requestLog) throws Throwable {

        long startTime = System.currentTimeMillis();

        Object object = null;

        String argsArr = StringUtils.EMPTY;
        String resJson = StringUtils.EMPTY;
        String err = StringUtils.EMPTY;
        long endTime = 0L;

        try {
            Object[] args = point.getArgs();
            if (ArrayUtils.isNotEmpty(args)) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < args.length; i++) {
                    sb.append(i).append(":").append(JsonJava8Util.toJson(args[i]));
                }

                argsArr = sb.toString();
            }

            object = point.proceed();

        } catch (Throwable throwable) {
            endTime = System.currentTimeMillis();
            err = throwable.getMessage();

            log.error("MethodAopLog拦截到的异常 -> module: {} apiUrl: {} Args:{} startTime: {}, endTime: {}, use: {}ms error: {} " , requestLog.module(), requestLog.apiUrl(), argsArr, startTime, endTime, (endTime - startTime), err, throwable);

            // @TODO 处理异步保存
            // 继续往外抛，以免事务回滚失败
            throw throwable;
        }

        resJson = JsonJava8Util.toJson(object);
        endTime = System.currentTimeMillis();

        if (RequestLog.Level.INFO.name().equals(requestLog.level().name())) {
            log.info("module: {} apiUrl: {} Args:{} res: {} startTime: {}, endTime: {}, use: {}ms error: {}", requestLog.module(), requestLog.apiUrl(), argsArr, resJson, startTime, endTime, (endTime - startTime), err);
        }
        else if (RequestLog.Level.DEBUG.name().equals(requestLog.level().name())) {
            log.debug("module: {} apiUrl: {} Args:{} res: {} startTime: {}, endTime: {}, use: {}ms error: {}", requestLog.module(), requestLog.apiUrl(), argsArr, resJson, startTime, endTime, (endTime - startTime), err);
        }
        return object;
    }
}
