package com.rocogz.syy.common.tencent.config;

import com.rocogz.syy.common.tencent.QQMapService;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.task.TaskExecutionAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.client.RestTemplate;

/**
 * qq地图自动配置类
 * @author zhangmin
 * @date 2020/4/8
 */
@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties(QQMapProperties.class)
@AutoConfigureAfter({TaskExecutionAutoConfiguration.class,WebMvcAutoConfiguration.class})
@ConditionalOnProperty(prefix = "qq.map", name = "key")
public class QQMapAutoConfiguration {

    @Autowired
    private QQMapProperties props;

    @ConditionalOnMissingBean
    @Bean
    public RestTemplate restTemplate() {
        HttpClient client = HttpClientBuilder.create().build();
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory(client);

        factory.setReadTimeout(15_000);
        factory.setConnectTimeout(15_000);
        return new RestTemplate(factory);
    }

    @Bean
    public QQMapService qqMapService() {
        return new QQMapService(props);
    }

}
