/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.common.aliyunoss.config;

import com.rocogz.syy.common.aliyunoss.config.AliyunOssProperties;
import com.rocogz.syy.common.aliyunoss.service.UploadService;
import java.io.File;
import javax.servlet.MultipartConfigElement;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.task.TaskExecutionAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.unit.DataSize;

@Configuration
@ConditionalOnMissingBean(value={UploadService.class})
@EnableConfigurationProperties(value={AliyunOssProperties.class})
@AutoConfigureAfter(value={TaskExecutionAutoConfiguration.class})
@ConditionalOnProperty(prefix="aliyun.oss.config", name={"isopen"}, havingValue="true")
public class AliyunOssConfig {
    @Autowired
    private AliyunOssProperties ssoProperties;

    @Bean
    public UploadService uploadService(ThreadPoolTaskExecutor threadPoolTaskExecutor) {
        return new UploadService(this.ssoProperties, threadPoolTaskExecutor);
    }

    @ConditionalOnMissingBean
    @Bean
    public MultipartConfigElement multipartConfigElement() {
        MultipartConfigFactory factory = new MultipartConfigFactory();
        DataSize maxSize = DataSize.ofBytes((long)0x6400000L);
        String projectDirPath = System.getProperty("user.dir");
        String activityUploadTmpDir = projectDirPath + "/uploadTmpDir";
        File uploadTempDir = new File(activityUploadTmpDir);
        if (!uploadTempDir.exists()) {
            uploadTempDir.mkdirs();
        }
        factory.setLocation(activityUploadTmpDir);
        factory.setMaxFileSize(maxSize);
        factory.setMaxRequestSize(maxSize);
        return factory.createMultipartConfig();
    }
}

