/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.common.aliyunoss.service;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.StorageClass;
import com.rocogz.syy.common.aliyunoss.config.AliyunOssProperties;
import com.rocogz.syy.common.response.Response;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.Asserts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class UploadService {
    private Logger logger = LoggerFactory.getLogger(UploadService.class);
    private DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private AliyunOssProperties ssoProperties;

    public UploadService() {
    }

    public UploadService(AliyunOssProperties ssoProperties, ThreadPoolTaskExecutor threadPoolTaskExecutor) {
        this.ssoProperties = ssoProperties;
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
        this.init();
    }

    public void init() {
        this.checkAliyunProperties();
        this.initBucket();
    }

    private void checkAliyunProperties() {
        Asserts.check((boolean)Objects.nonNull(this.ssoProperties), (String)"\u963f\u91cc\u4e91\u6240\u9700\u8981\u914d\u7f6e\u7f3a\u5931");
        Asserts.check((boolean)StringUtils.isNotEmpty((CharSequence)this.ssoProperties.getAccessKeyId()), (String)"\u963f\u91cc\u4e91\u6743\u9650\u8ba4\u8bc1\uff1aAccessKeyId \u7f3a\u5931");
        Asserts.check((boolean)StringUtils.isNotEmpty((CharSequence)this.ssoProperties.getAccessKeySecret()), (String)"\u963f\u91cc\u4e91\u6743\u9650\u8ba4\u8bc1\uff1aaccessKeySecret \u7f3a\u5931");
        Asserts.check((boolean)StringUtils.isNotEmpty((CharSequence)this.ssoProperties.getBucket()), (String)"\u963f\u91cc\u4e91\u6743\u9650\u8ba4\u8bc1\uff1abucket \u7f3a\u5931");
        Asserts.check((boolean)StringUtils.isNotEmpty((CharSequence)this.ssoProperties.getEndpoint()), (String)"\u963f\u91cc\u4e91\u6743\u9650\u8ba4\u8bc1\uff1aendpoint \u7f3a\u5931");
    }

    public OSSClient getOSSClient() {
        int connectTimeOut = 10000;
        ClientConfiguration config = new ClientConfiguration();
        config.setRequestTimeoutEnabled(true);
        config.setConnectionTimeout(connectTimeOut);
        config.setRequestTimeout(connectTimeOut);
        config.setConnectionRequestTimeout(connectTimeOut);
        config.setSocketTimeout(15000);
        DefaultCredentialProvider provider = new DefaultCredentialProvider(this.ssoProperties.getAccessKeyId(), this.ssoProperties.getAccessKeySecret());
        return new OSSClient(this.ssoProperties.getEndpoint(), (CredentialsProvider)provider, config);
    }

    private void initBucket() {
        OSSClient ossClient = this.getOSSClient();
        try {
            boolean exists = ossClient.doesBucketExist(this.ssoProperties.getBucket());
            if (!exists) {
                CreateBucketRequest cbr = new CreateBucketRequest(this.ssoProperties.getBucket());
                cbr.setCannedACL(CannedAccessControlList.PublicRead);
                cbr.setStorageClass(StorageClass.Standard);
                ossClient.createBucket(cbr);
            }
        }
        catch (Exception ex) {
            this.logger.error("initBucket error,", (Throwable)ex);
        }
    }

    public String fileUpload(InputStream inputStream, String originName, String type, String[] thumbImgSizeList) {
        String uniqueId = this.getUniqueId(type);
        StringBuilder mainFileName = new StringBuilder();
        String fileSubfix = this.getFileSubfix(originName);
        mainFileName.append(uniqueId).append(fileSubfix);
        byte[] data = this.streamToByteArray(inputStream);
        String mainUrl = this.fileUploadByString(new ByteArrayInputStream(data), originName, type, mainFileName.toString());
        if (ArrayUtils.isNotEmpty((Object[])thumbImgSizeList)) {
            for (String imageStr : thumbImgSizeList) {
                String[] img = imageStr.split("_");
                StringBuilder thumb = new StringBuilder();
                thumb.append(uniqueId).append(imageStr).append(fileSubfix);
                this.threadPoolTaskExecutor.submit((Callable)new ZipImage(data, Integer.valueOf(img[0]), Integer.valueOf(img[1]), originName, type, thumb.toString()));
            }
        }
        return mainUrl;
    }

    public String fileUpload(InputStream inputStream, String fileName, String type) {
        StringBuilder key = new StringBuilder(type);
        key.append("/");
        key.append(this.getDateString());
        key.append("/");
        key.append(fileName);
        byte[] data = this.streamToByteArray(inputStream);
        String mainUrl = this.fileUploadByString(new ByteArrayInputStream(data), fileName, type, key.toString());
        return mainUrl;
    }

    public String fileSaveToLocal(InputStream inputStream, String originName) {
        return this.fileSave(inputStream, this.ssoProperties.getLocalDirectory(), originName);
    }

    public String fileSaveToTmpLocal(InputStream inputStream, String originName) {
        return this.fileSave(inputStream, this.ssoProperties.getLocalTmpDirectory(), originName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fileSave(InputStream inputStream, String directory, String originName) {
        String path = directory + File.separator + LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")) + File.separator + LocalDateTime.now().format(DateTimeFormatter.ofPattern("HHmmss")) + "-" + originName;
        try {
            File target = new File(path);
            if (!target.getParentFile().exists()) {
                target.getParentFile().mkdirs();
            }
            this.logger.info("\u5f00\u59cb\u4fdd\u5b58\u6587\u4ef6[{}]", (Object)originName);
            Files.copy(inputStream, target.toPath(), new CopyOption[0]);
            this.logger.info("\u6587\u4ef6[{}]\u5df2\u4fdd\u5b58\u5230[{}]", (Object)originName, (Object)directory);
        }
        catch (IOException e) {
            this.logger.error("\u4fdd\u5b58[{}]\u6587\u4ef6\u5931\u8d25 -> ", (Object)originName, (Object)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return path;
    }

    public Response generateThumb(InputStream inputStream, String type, String originName, String[] thumbImgSizeList, long fileSize) {
        String[] img;
        String uniqueId = this.getUniqueId(type);
        StringBuilder mainFileName = new StringBuilder();
        String fileSubfix = this.getFileSubfix(originName);
        mainFileName.append(uniqueId).append(fileSubfix);
        byte[] data = this.streamToByteArray(inputStream);
        try {
            if (ArrayUtils.isNotEmpty((Object[])thumbImgSizeList)) {
                ByteArrayInputStream originInputStream = new ByteArrayInputStream(data);
                BufferedImage originImage = ImageIO.read(originInputStream);
                for (String imageStr : thumbImgSizeList) {
                    img = imageStr.split("_");
                    if (originImage.getWidth() >= Integer.valueOf(img[0]) && originImage.getHeight() >= Integer.valueOf(img[1])) continue;
                    return Response.failure((String)"\u539f\u56fe\u5c3a\u5bf8\u5c0f\u4e8e\u538b\u7f29\u540e\u7684\u5c3a\u5bf8");
                }
            }
        }
        catch (IOException e) {
            this.logger.error("\u56fe\u7247\u5c3a\u5bf8\u68c0\u67e5\u5931\u8d25{}", (Throwable)e);
            return Response.failure((String)"\u56fe\u7247\u5c3a\u5bf8\u68c0\u67e5\u5931\u8d25");
        }
        String mainUrl = this.fileUploadByString(new ByteArrayInputStream(data), originName, type, mainFileName.toString());
        HashMap<String, Object> thumbPathsMap = new HashMap<String, Object>();
        if (ArrayUtils.isNotEmpty((Object[])thumbImgSizeList)) {
            for (String imageStr : thumbImgSizeList) {
                img = imageStr.split("_");
                StringBuilder thumb = new StringBuilder();
                thumb.append(uniqueId).append(imageStr);
                Future mapFuture = this.threadPoolTaskExecutor.submit((Callable)new ThumbImage(data, Integer.valueOf(img[0]), Integer.valueOf(img[1]), originName, type, thumb.toString()));
                try {
                    List paths = (List)mapFuture.get();
                    thumbPathsMap.put(imageStr, paths);
                }
                catch (Exception e) {
                    this.logger.error("\u521b\u5efa\u7f29\u7565\u56fe\u5931\u8d25{}", (Throwable)e);
                    return Response.failure((String)"\u521b\u5efa\u7f29\u7565\u56fe\u5931\u8d25");
                }
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("fileSize", fileSize);
        result.put("path", mainUrl);
        result.put("fileName", originName);
        result.put("type", type);
        thumbPathsMap.put("mainImage", result);
        return Response.succeed(thumbPathsMap);
    }

    public String fileUploadByString(InputStream inputStream, String originName, String type) {
        return this.fileUploadByString(inputStream, originName, type, this.getUniqueKey(originName, type));
    }

    public void selectTempThumb(String[] fileUrls) {
        for (String fileUrl : fileUrls) {
            String tempThumbKey = fileUrl.substring(fileUrl.lastIndexOf("/") + 1);
            String formatName = tempThumbKey.substring(tempThumbKey.lastIndexOf(".") + 1);
            String thumbKey = tempThumbKey.substring(0, tempThumbKey.lastIndexOf("_")) + "." + formatName;
            OSSClient ossClient = this.getOSSClient();
            OSSObject ossObject = ossClient.getObject(this.ssoProperties.getBucket(), tempThumbKey);
            ossClient.putObject(this.ssoProperties.getBucket(), thumbKey, ossObject.getObjectContent());
            ossClient.deleteObject(this.ssoProperties.getBucket(), tempThumbKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fileUploadByString(InputStream inputStream, String originName, String type, String key) {
        Long startTime = System.currentTimeMillis();
        this.logger.info("\u6587\u4ef6\u4e0a\u4f20\u5230oss\u5f00\u59cb");
        OSSClient ossClient = this.getOSSClient();
        try {
            ossClient.putObject(this.ssoProperties.getBucket(), key, inputStream);
        }
        finally {
            ossClient.shutdown();
        }
        StringBuilder buffer = this.constructionPath(key);
        this.logger.info("\u6587\u4ef6\u4e0a\u4f20\u5230oss\u5b8c\u6210,\u8017\u65f6{}ms", (Object)(System.currentTimeMillis() - startTime));
        return buffer.toString();
    }

    private StringBuilder constructionPath(String key) {
        String point = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.ssoProperties.getVisitEndPoint()}) ? this.ssoProperties.getVisitEndPoint() : this.ssoProperties.getEndpoint();
        String[] paths = point.split("//");
        StringBuilder buffer = new StringBuilder();
        buffer.append(paths[0]).append("//").append(this.ssoProperties.getBucket()).append(".").append(paths[1]).append("/").append(key);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] streamToByteArray(InputStream inputStream) {
        byte[] tmp = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int i = 0;
        try {
            while ((i = inputStream.read(tmp)) != -1) {
                byteArrayOutputStream.write(tmp, 0, i);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void deleteObject(String key) {
        OSSClient ossClient = this.getOSSClient();
        ossClient.deleteObject(this.ssoProperties.getBucket(), key);
    }

    public String getUniqueKey(String originName, String type) {
        StringBuilder key = new StringBuilder();
        key.append(this.getUniqueId(type));
        key.append(this.getFileSubfix(originName));
        return key.toString();
    }

    public String getFileSubfix(String originName) {
        if (originName.indexOf(".") != -1) {
            return originName.substring(originName.lastIndexOf("."));
        }
        return "";
    }

    public String getUniqueId(String type) {
        StringBuilder key = new StringBuilder(type);
        key.append("/").append(this.getDateString()).append("_").append(this.getUUID());
        return key.toString();
    }

    private String getDateString() {
        return LocalDate.now().format(this.formatter);
    }

    private String getUUID() {
        String uuid = UUID.randomUUID().toString();
        return uuid.replace("-", "");
    }

    private byte[] resize(byte[] data, String formatName, int width, int height) throws IOException {
        BufferedImage src = Thumbnails.of((InputStream[])new InputStream[]{new ByteArrayInputStream(data)}).outputQuality(0.8f).size(width, height).asBufferedImage();
        return this.paddingWhite(src, formatName, width, height).toByteArray();
    }

    private byte[] resize(byte[] data, String formatName, double scale) throws IOException {
        BufferedImage src = Thumbnails.of((InputStream[])new InputStream[]{new ByteArrayInputStream(data)}).outputQuality(0.8f).scale(scale).asBufferedImage();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)src, formatName, out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    private byte[] resize(InputStream is, String formatName, int width, int height) throws IOException {
        BufferedImage src = Thumbnails.of((InputStream[])new InputStream[]{is}).outputQuality(0.8f).size(width, height).asBufferedImage();
        return this.paddingWhite(src, formatName, width, height).toByteArray();
    }

    private ByteArrayOutputStream resize(byte[] data, Positions positions, int width, int height, String formatName) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            BufferedImage bufferedImage = Thumbnails.of((InputStream[])new InputStream[]{new ByteArrayInputStream(data)}).sourceRegion((Position)positions, width, height).outputQuality(0.8f).size(width, height).asBufferedImage();
            ImageIO.write((RenderedImage)bufferedImage, formatName, byteArrayOutputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return byteArrayOutputStream;
    }

    private ByteArrayOutputStream paddingWhite(BufferedImage src, String formatName, int targetWidth, int targetHeight) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int width = src.getWidth();
        int height = src.getHeight();
        if (width == targetWidth && height == targetHeight) {
            try {
                ImageIO.write((RenderedImage)src, formatName, out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return out;
        }
        BufferedImage target = new BufferedImage(targetWidth, targetHeight, src.getType());
        Graphics2D graphics = target.createGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, targetWidth, targetHeight);
        int x = 0;
        int y = 0;
        if (targetWidth > width) {
            x = (targetWidth - width) / 2;
        }
        if (targetHeight > height) {
            y = (targetHeight - height) / 2;
        }
        graphics.drawImage(src, null, x, y);
        graphics.dispose();
        try {
            ImageIO.write((RenderedImage)target, formatName, out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out;
    }

    class ThumbImage
    implements Callable<List<String>> {
        private int width;
        private int height;
        private String fileName;
        private String type;
        private String key;
        private byte[] data;

        public ThumbImage(byte[] data, int width, int height, String fileName, String type, String key) {
            this.width = width;
            this.height = height;
            this.fileName = fileName;
            this.type = type;
            this.key = key;
            this.data = data;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public byte[] getData() {
            return this.data;
        }

        public void setData(byte[] data) {
            this.data = data;
        }

        @Override
        public List<String> call() throws Exception {
            String formatName = this.fileName.substring(this.fileName.lastIndexOf(".") + 1);
            ByteArrayInputStream originInputStream = new ByteArrayInputStream(this.getData());
            BufferedImage originImage = ImageIO.read(originInputStream);
            BigDecimal bigOriginWidth = new BigDecimal(originImage.getWidth());
            BigDecimal bigOriginHeight = new BigDecimal(originImage.getHeight());
            BigDecimal bigTargetWidth = new BigDecimal(this.getWidth());
            BigDecimal bigTargetHeight = new BigDecimal(this.getHeight());
            ArrayList<String> paths = new ArrayList<String>();
            if (this.getWidth() <= originImage.getWidth() && this.getHeight() <= originImage.getHeight()) {
                if (this.getWidth() / originImage.getWidth() == this.getHeight() / originImage.getHeight() && this.getWidth() % originImage.getWidth() == this.getHeight() % originImage.getHeight()) {
                    byte[] thumbData = UploadService.this.resize(this.getData(), formatName, this.getWidth(), this.getHeight());
                    String imagePath = UploadService.this.fileUploadByString(new ByteArrayInputStream(thumbData), this.getFileName(), this.getType(), this.getKey() + "." + formatName);
                    paths.add(imagePath);
                } else {
                    double widthRatio = bigTargetWidth.divide(bigOriginWidth, 10, 4).doubleValue();
                    double heightRatio = bigTargetHeight.divide(bigOriginHeight, 10, 4).doubleValue();
                    if (bigTargetWidth.divide(bigOriginWidth, 10, 4).multiply(bigOriginHeight).doubleValue() > bigTargetHeight.doubleValue()) {
                        byte[] thumbData = UploadService.this.resize(this.getData(), formatName, widthRatio);
                        ByteArrayOutputStream byteArrayOutputStreamTopCenter = UploadService.this.resize(thumbData, Positions.TOP_CENTER, this.getWidth(), this.getHeight(), formatName);
                        String topCenterImagePath = UploadService.this.fileUploadByString(new ByteArrayInputStream(byteArrayOutputStreamTopCenter.toByteArray()), this.getFileName(), this.getType(), this.getKey() + "." + formatName);
                        paths.add(topCenterImagePath);
                    } else if (bigTargetHeight.divide(bigOriginHeight, 10, 4).multiply(bigOriginWidth).doubleValue() > bigTargetWidth.doubleValue()) {
                        byte[] thumbData = UploadService.this.resize(this.getData(), formatName, heightRatio);
                        ByteArrayOutputStream byteArrayOutputStreamCenter = UploadService.this.resize(thumbData, Positions.CENTER, this.getWidth(), this.getHeight(), formatName);
                        String centerImagePath = UploadService.this.fileUploadByString(new ByteArrayInputStream(byteArrayOutputStreamCenter.toByteArray()), this.getFileName(), this.getType(), this.getKey() + "." + formatName);
                        paths.add(centerImagePath);
                    }
                }
            }
            return paths;
        }
    }

    class ZipImage
    implements Callable<String> {
        private int width;
        private int height;
        private String fileName;
        private String type;
        private String key;
        private byte[] data;

        public ZipImage(byte[] data, int width, int height, String fileName, String type, String key) {
            this.width = width;
            this.height = height;
            this.fileName = fileName;
            this.type = type;
            this.key = key;
            this.data = data;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public byte[] getData() {
            return this.data;
        }

        public void setData(byte[] data) {
            this.data = data;
        }

        @Override
        public String call() throws Exception {
            String formatName = this.fileName.substring(this.fileName.lastIndexOf(".") + 1);
            byte[] data = UploadService.this.resize(this.getData(), formatName, this.getWidth(), this.getHeight());
            return UploadService.this.fileUploadByString(new ByteArrayInputStream(data), this.getFileName(), this.getType(), this.getKey());
        }
    }
}

