package com.rocogz.linkcustomerequity.client;

import com.rocogz.linkcustomerequity.dto.login.AgentUser;
import com.rocogz.linkcustomerequity.dto.product.Product;
import com.rocogz.linkcustomerequity.dto.product.ProductReq;
import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @Author zhanghongshan
 * @date 2020/10/29 4:50 下午
 */
public interface IAgentUserClientService {

    @GetMapping({"/api/agent/userLogin"})
    Response<AgentUser> userLogin(@RequestParam("account") String account , @RequestParam("password")String password, @RequestParam("wxid")String wxid);

    @GetMapping({"/api/agent/updatePassword"})
    Response<AgentUser> updatePassword(@RequestParam("account") String account , @RequestParam("password")String password, @RequestParam("wxid")String wxid);

    @PostMapping("/api/product/list")
    Response<List<Product>> list(@RequestBody ProductReq req);

    @PostMapping("/api/product/pageList")
    PageTable<Product> pageList(@RequestBody ProductReq req);

    @GetMapping("/api/agent/userInfo")
    Response<AgentUser> userInfo(@RequestParam("code") String code);
}
