package com.rocogz.linkcustomerequity.client;

import com.rocogz.linkcustomerequity.dto.AccountTradeInfoDTO;
import com.rocogz.syy.common.response.Response;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;

/**
 * @author djt
 * @Description:
 * @date 2020/10/29 18:22
 */
public interface ILinkCustomerEquityClientService {

    /**
     * 扣减机构账户额度
     * @param acctName 个人账户编码
     * @param enterpriseCode 机构编码
     * @param amount 扣减金额
     * @param orderNo 订单编号
     * @return
     */
    @GetMapping("/api/account/deduct")
     Response<AccountTradeInfoDTO> deduct(@RequestParam("acctName") String acctName, @RequestParam("enterpriseCode") String enterpriseCode, @RequestParam("amount") BigDecimal amount, @RequestParam("orderNo") String orderNo);
}
