package com.rocogz.linkcustomerequity.client;

import com.rocogz.linkcustomerequity.dto.AccountTradeInfoDTO;
import com.rocogz.linkcustomerequity.dto.enterprise.OilAccountConfResp;
import com.rocogz.linkcustomerequity.dto.gift.Gift;
import com.rocogz.linkcustomerequity.dto.gift.GiftReq;
import com.rocogz.linkcustomerequity.dto.login.AgentUser;
import com.rocogz.linkcustomerequity.dto.product.Product;
import com.rocogz.linkcustomerequity.dto.product.ProductReq;
import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Author zhanghongshan
 * @date 2020/10/29 4:50 下午
 */
public interface IAgentUserClientService {

    @GetMapping({"/api/agent/userLogin"})
    Response<AgentUser> userLogin(@RequestParam("account") String account , @RequestParam("password")String password, @RequestParam("wxid")String wxid);

    @GetMapping({"/api/agent/updatePassword"})
    Response<AgentUser> updatePassword(@RequestParam("account") String account , @RequestParam("password")String password, @RequestParam("wxid")String wxid);

    @PostMapping("/api/product/list")
    Response<List<Product>> list(@RequestBody ProductReq req);

    @PostMapping("/api/product/pageList")
    PageTable<Product> pageList(@RequestBody ProductReq req);

    @GetMapping("/api/agent/userInfo")
    Response<AgentUser> userInfo(@RequestParam(value = "code",required = false) String code ,
                                 @RequestParam(value = "openid",required = false) String openid);

    @PostMapping("/api/gift/list")
    PageTable<Gift> list(@RequestBody GiftReq req);

    @GetMapping("/api/enterprise/conf")
     Response<OilAccountConfResp> getByEnterpriseCode(@RequestParam("enterpriseCode")String enterpriseCode);

    @PostMapping("/api/account/depositDeduct")
    Response<AccountTradeInfoDTO> depositDeduct(@RequestParam("enterpriseCode") String enterpriseCode,
                                                @RequestParam("mobile") String mobile,
                                                @RequestParam("amount") BigDecimal amount,
                                                @RequestParam("orderNo") String orderNo);
}
