package com.rocogz.merchant.client;

import com.rocogz.merchant.client.goods.ReqParamGoods;
import com.rocogz.merchant.client.insurance.ReqParamGift;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.dto.EvaluateDto;
import com.rocogz.merchant.dto.FilterAreaCountDto;
import com.rocogz.merchant.dto.GasStationDto;
import com.rocogz.merchant.dto.TreeDto;
import com.rocogz.merchant.dto.goods.GoodsStockAdminAdjustRequestDto;
import com.rocogz.merchant.dto.goods.GoodsVcardStockPageRequestDto;
import com.rocogz.merchant.dto.goodsStock.OrderBatchStockRequestDto;
import com.rocogz.merchant.dto.goodsStock.OrderStockRequestDTO;
import com.rocogz.merchant.dto.goodsStock.OrderVCardResponseItem;
import com.rocogz.merchant.dto.goodsVcard.VCardToVoidRequestDTO;
import com.rocogz.merchant.entity.areaservice.MerchantAreaService;
import com.rocogz.merchant.entity.areaservice.MerchantAreaServiceSettlement;
import com.rocogz.merchant.entity.brand.MerchantBrand;
import com.rocogz.merchant.entity.evaluate.MerchantEvaluateKpi;
import com.rocogz.merchant.entity.exchangeGoods.MerchantExchangeGoods;
import com.rocogz.merchant.entity.exchangeGoods.MerchantExchangeGoodsLog;
import com.rocogz.merchant.entity.exchangeGoods.MerchantExchangeGoodsSpecialPrice;
import com.rocogz.merchant.entity.goods.*;
import com.rocogz.merchant.entity.identity.MerchantStoreAccountIdentity;
import com.rocogz.merchant.entity.impressionLabel.MerchantAreaServiceImpressionLabel;
import com.rocogz.merchant.entity.industry.MerchantIndustry;
import com.rocogz.merchant.entity.insuranceGift.*;
import com.rocogz.merchant.entity.label.MerchantLabel;
import com.rocogz.merchant.entity.rocomall.MerchantRocoMallGoods;
import com.rocogz.merchant.entity.rocomall.MerchantRocoMallGoodsLog;
import com.rocogz.merchant.entity.rocomall.MerchantRocoMallGoodsSpecialPrice;
import com.rocogz.merchant.entity.service.ServiceClassification;
import com.rocogz.merchant.entity.service.ServiceClassificationIndustry;
import com.rocogz.merchant.entity.store.*;
import com.rocogz.merchant.entity.storeservice.*;
import com.rocogz.merchant.entity.supplier.MerchantSupplier;
import com.rocogz.merchant.entity.supplier.MerchantSupplierUlog;
import com.rocogz.merchant.entity.type.MerchantType;
import com.rocogz.merchant.pager.Sort;
import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 商户接口
 *
 * @author：liangyongtong
 * @since：2020/3/25
 */
public interface IMerchantClientService {

    /*********************************************  liangyongtong 商户相关 Start   ****************************************************************/
    /**
     * 更新保存商户
     *
     * @param store
     * @return
     */
    @PostMapping("/api/merchant/store")
    Response<String> saveMerchantStore(@RequestBody MerchantStore store);

    /**
     * 上架审批回调接口
     *
     * @param pass
     * @param code
     * @param updateUser
     * @return
     */
    @GetMapping("/api/merchant/store/storeApproveCallBlack")
    Response storeApproveCallBlack(@RequestParam(value = "pass") String pass, @RequestParam(value = "code") String code, @RequestParam(value = "updateUser") String updateUser);

    /**
     * 商户列表数据查询
     *
     * @param keyword        名称 模糊匹配
     * @param code           编码 全匹配
     * @param areaCode       专区编码 全匹配
     * @param industryCode   行业编码 全匹配
     * @param settlementCode 结算编码 全匹配
     * @param type           商户类型
     * @param status         商户状态
     * @param limit          每页条数
     * @param page           页码
     * @return
     */
    @GetMapping("/api/merchant/store/queryPage")
    PageTable<MerchantStore> merchantStorePageTable(@RequestParam(value = "keyword", required = false) String keyword,
                                                    @RequestParam(value = "code", required = false) String code,
                                                    @RequestParam(value = "areaCode", required = false) String areaCode,
                                                    @RequestParam(value = "industryCode", required = false) String industryCode,
                                                    @RequestParam(value = "settlementCode", required = false) String settlementCode,
                                                    @RequestParam(value = "type", required = false) String type,
                                                    @RequestParam(value = "status", required = false) String status,
                                                    @RequestParam(name = "settleSubjectList", required = false) List<String> settleSubjectList,
                                                    @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                    @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 商户列表Code数据查询
     *
     * @param keyword        名称 模糊匹配
     * @param code           编码 全匹配
     * @param areaCode       专区编码 全匹配
     * @param industryCode   行业编码 全匹配
     * @param settlementCode 结算编码 全匹配
     * @param type           商户类型
     * @param status         商户状态
     * @return
     */
    @GetMapping("/api/merchant/store/gainMerchantStoreCodeList" )
    public Response<List<MerchantStore>> gainMerchantStoreCodeList(@RequestParam(value = "keyword", required = false) String keyword,
                                                                   @RequestParam(value = "code", required = false) String code,
                                                                   @RequestParam(value = "areaCode", required = false) String areaCode,
                                                                   @RequestParam(value = "industryCode", required = false) String industryCode,
                                                                   @RequestParam(value = "settlementCode", required = false) String settlementCode,
                                                                   @RequestParam(value = "type", required = false) String type,
                                                                   @RequestParam(value = "status", required = false) String status,
                                                                   @RequestParam(name = "settleSubjectList", required = false) List<String> settleSubjectList);

    /**
     * 商户列表数据查询(主表)
     *
     * @param keyword        名称 模糊匹配
     * @param code           编码 全匹配
     * @param areaCode       专区编码 全匹配
     * @param industryCode   行业编码 全匹配
     * @param settlementCode 结算编码 全匹配
     * @param type           商户类型
     * @param status         商户状态
     * @param limit          每页条数
     * @param page           页码
     * @return
     */
    @GetMapping("/api/merchant/store/basicQueryPage")
    PageTable<MerchantStore> merchantStoreBasicPageTable(@RequestParam(value = "keyword", required = false) String keyword,
                                                         @RequestParam(value = "code", required = false) String code,
                                                         @RequestParam(value = "areaCode", required = false) String areaCode,
                                                         @RequestParam(value = "industryCode", required = false) String industryCode,
                                                         @RequestParam(value = "settlementCode", required = false) String settlementCode,
                                                         @RequestParam(value = "type", required = false) String type,
                                                         @RequestParam(value = "status", required = false) String[] status,
                                                         @RequestParam(name = "settleSubjectList", required = false) List<String> settleSubjectList,
                                                         @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                         @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 操作商户状态
     *
     * @param code       商户编码
     * @param status     目标商户状态
     * @param updateUser 更新用户
     * @return
     */
    @GetMapping("/api/merchant/store/operateStatus")
    Response merchantStoreStatusOperate(@RequestParam(value = "code") String code, @RequestParam(value = "status") String status, @RequestParam(value = "updateUser") String updateUser);

    /**
     * 根据商户编码删除商户
     *
     * @param code 商户编码
     * @return
     */
    @GetMapping("/api/merchant/store/deleteStore")
    Response merchantStoreDeleteByCode(@RequestParam(value = "code") String code);

    /**
     * 根据商户编码获取商户详情
     *
     * @param code 商户编码
     * @return
     */
    @GetMapping("/api/merchant/store/storeDetail")
    Response<MerchantStore> merchantStoreDetailByCode(@RequestParam(value = "code") String code);

    /**
     * 更新保存账号信息
     *
     * @param account 账号对象
     * @return
     */
    @PostMapping("/api/merchant/store/account")
    Response merchantStoreAccountSave(@RequestBody MerchantStoreAccount account);

    /**
     * 商户账号列表查询
     *
     * @param storeCode 商户编码
     * @return
     */
    @GetMapping("/api/merchant/store/account/queryPage")
    PageTable<MerchantStoreAccount> merchantStoreAccountPageTable(@RequestParam(value = "storeCode") String storeCode,
                                                                  @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                                  @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 商户账号管理-列表查询
     *
     * @param storeCode
     * @param code
     * @param name
     * @param mobile
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/account/queryPage")
    PageTable<MerchantStoreAccount> merchantStoreAccountPageTable(@RequestParam(value = "storeCode", required = false) String storeCode,
                                                                  @RequestParam(value = "code", required = false) String code,
                                                                  @RequestParam(value = "name", required = false) String name,
                                                                  @RequestParam(value = "mobile", required = false) String mobile,
                                                                  @RequestParam(value = "areaCode", required = false) String areaCode,
                                                                  @RequestParam(value = "settlementCode", required = false) String settlementCode,
                                                                  @RequestParam(value = "prefectureCodes", required = false) List<String> prefectureCodes,
                                                                  @RequestParam(value = "settleSubjectCodes", required = false) List<String> settleSubjectCodes,
                                                                  @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                                  @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 导出商户账号列表查询
     *
     *
     * @param storeCode 商户编码
     * @return
     */
    @GetMapping("/api/merchant/account/merchantStoreAccountList")
    Response<List<MerchantStoreAccount>> merchantStoreAccountList(@RequestParam(value = "storeCode", required = false) String storeCode,
                                                                  @RequestParam(value = "code", required = false) String code,
                                                                  @RequestParam(value = "name", required = false) String name,
                                                                  @RequestParam(value = "mobile", required = false) String mobile,
                                                                  @RequestParam(value = "areaCode", required = false) String areaCode,
                                                                  @RequestParam(value = "settlementCode", required = false) String settlementCode,
                                                                  @RequestParam(value = "prefectureCodes", required = false) List<String> prefectureCodes,
                                                                  @RequestParam(value = "settleSubjectCodes", required = false) List<String> settleSubjectCodes);


    /**
     * 根据商户编码查询对应的账号列表
     *
     * @param storeCode 商户编码
     * @param status    账号状态
     * @return
     */
    @GetMapping("/api/merchant/store/account/queryList")
    Response<List<MerchantStoreAccount>> merchantStoreAccountListByStoreCode(@RequestParam(value = "storeCode") String storeCode,
                                                                             @RequestParam(value = "status", required = false) String status);

    /**
     * 更改商户账号状态
     *
     * @param code   商户账号编码
     * @param status 目标状态
     * @return
     */
    @GetMapping("/api/merchant/store/account/operateStatus")
    Response merchantStoreAccountStatusOperate(@RequestParam(value = "code") String code, @RequestParam(value = "status") String status, @RequestParam(value = "operateUser") String operateUser);

    /**
     * 重置商户账号密码
     *
     * @param code 待重置密码的商户账号编码
     * @return
     */
    @GetMapping("/api/merchant/store/account/resetpassword")
    Response merchantStoreAccountResetPassword(@RequestParam(value = "code") String code, @RequestParam(value = "newPass", required = false) String newPass, @RequestParam(value = "operateUser") String operateUser);

    /**
     * 根据手机号返回账号列表
     *
     * @param mobile 手机号
     * @return
     */
    @GetMapping("/api/merchant/store/account/listbymobile")
    Response<List<MerchantStoreAccount>> merchantStoreAccountListByMobile(@RequestParam(value = "mobile") String mobile);

    /**
     * 商户操作日志记录
     *
     * @param storeCode 商户编码
     * @param limit     每页条数
     * @param page      页码
     * @return
     */
    @GetMapping("/api/merchant/store/ulog/queryPage")
    PageTable<MerchantStoreUlog> merchantStoreUlogPageTable(@RequestParam(value = "storeCode") String storeCode,
                                                            @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                            @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 根据商户编码获取商户基本信息 (merchant_store 表数据)
     *
     * @param code 商户编码
     * @return
     */
    @GetMapping("/api/merchant/store/storeBaseDetail")
    Response<MerchantStore> merchantStoreBaseInfoByCode(@RequestParam(value = "code") String code);

    /**
     * 更新商户基本信息表数据
     *
     * @param store 商户信息
     * @return
     */
    @PostMapping("/api/merchant/store/baseinfo")
    Response merchantStoreBaseSave(@RequestBody MerchantStore store);

    /**
     * 查询绑定过该商户账号的微信列表
     *
     * @param accountCode 商户账号
     * @return
     */
    @GetMapping("/api/merchant/store/account/wxlist")
    Response<List<MerchantStoreAccountLoginStatus>> merchantStoreAccountWxLoginList(@RequestParam(value = "accountCode") String accountCode);

    /**
     * 删除某个商户账号下关联的微信登录信息
     *
     * @param accountCode 商户账号
     * @param wxOpenid    关联的微信openid
     * @param operateUser 操作用户
     * @return
     */
    @GetMapping("/api/merchant/store/account/deletewx")
    Response merchantStoreAccountDeleteWx(@RequestParam(value = "accountCode") String accountCode, @RequestParam(value = "wxOpenid") String wxOpenid, @RequestParam(value = "operateUser") String operateUser);

    /**
     * 通过商户账号编码获取账号详情
     *
     * @param code 账号编码
     * @return
     */
    @GetMapping("/api/merchant/store/account/detail")
    Response<MerchantStoreAccount> merchantStoreAccountDetailByCode(@RequestParam(value = "code") String code);

    /**
     * 通过商户账号或者手机号查询列表
     *
     * @param codeOrMobile 商户账号或者手机号
     * @param status       状态，默认启用
     * @return
     */
    @GetMapping("/api/merchant/store/account/list/bycodeormobile")
    Response<List<MerchantStoreAccount>> merchantStoreAccountListByCodeOrMobile(@RequestParam(value = "codeOrMobile") String codeOrMobile, @RequestParam(value = "status", defaultValue = "OPEN") String status);

    /**
     * 通过商户账号和手机号查询
     *
     * @param storeCode 商户编码
     * @param mobile    手机号
     * @return
     */
    @GetMapping("/api/merchant/store/account/bystorecodeandmobile")
    Response<MerchantStoreAccount> merchantStoreAccountByStoreCodeAndMobile(@RequestParam(value = "storeCode") String storeCode, @RequestParam(value = "mobile") String mobile);

    /**
     * 按关联时间倒序返回登录关联列表
     *
     * @param openid openid
     * @return
     */
    @GetMapping("/api/merchant/store/account/statuslist")
    Response<List<MerchantStoreAccountLoginStatus>> merchantStoreAccountLoginStatusListByOpenid(@RequestParam(value = "openid") String openid);

    /**
     * 根据openid查询最新一个登录关联信息
     *
     * @param openid openid
     * @return
     */
    @GetMapping("/api/merchant/store/account/getLastLoginStatusByOpenid")
    Response<MerchantStoreAccountLoginStatus> merchantStoreAccountLastLoginStatusByOpenid(@RequestParam(value = "openid") String openid);

    /**
     * 保存或者更新账号登录状态
     *
     * @param loginStatus 账号登录状态记录
     * @return
     */
    @PostMapping("/api/merchant/store/account/loginstatus/save")
    Response merchantStoreAccountLoginStatusSaveOrUpdate(@RequestBody MerchantStoreAccountLoginStatus loginStatus);

    /**
     * 门店登录日志
     *
     * @param storeCode   门店编号
     * @param accountCode 门店账号
     */
    @GetMapping("/api/merchant/store/loginLog")
    PageTable<MerchantStoreLoginLog> findStoreLoginLogs(@RequestParam(value = "storeCode", required = false) String storeCode,
                                                        @RequestParam(value = "accountCode", required = false) String accountCode,
                                                        @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                        @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 保存门店登录日志
     */
    @PostMapping("/api/merchant/store/loginLog/save")
    Response<String> saveStoreLoginLog(@RequestBody MerchantStoreLoginLog loginLog);

    /**
     * 返回限制规则列表
     *
     * @param areaCode        专区编码
     * @param areaServiceCode 专区服务编码
     * @return 限制列表
     */
    @GetMapping("/api/merchant/store/limitRules")
    Response<List<MerchantLimitRules>> merchantLimitRulesByAreaCodeAndAreaServiceCode(@RequestParam(value = "areaCode") String areaCode,
                                                                                      @RequestParam(value = "areaServiceCode") String areaServiceCode);

    /**
     * 运营管理-首页推荐商户-根据商户codelist查询商户列表---yifenrui
     *
     * @param listCode
     * @return
     */
    @GetMapping("/api/merchant/store/merchantStoreListByListCode")
    Response<List<MerchantStore>> merchantStoreListByListCode(@RequestParam(value = "code") List<String> listCode);

    /**
     * 添加商户和商户服务的订单数量
     *
     * @param storeCode        商户编码
     * @param storeServiceCode 商户服务编码
     * @param count            新添加的订单数量
     * @return 添加结果
     */
    @GetMapping("/api/merchant/store/appendOrderCount")
    Response appendStoreOrderCount(@RequestParam(value = "storeCode") String storeCode, @RequestParam(value = "storeServiceCode") String storeServiceCode, @RequestParam(value = "count") int count);

    /**
     * 获取加油站商户列表
     *
     * @param lat    纬度
     * @param lng    经度
     * @param types  商户类型
     * @param brands 商户品牌
     * @return 商户列表
     */
    @GetMapping("/api/merchant/wx/store/gaslist")
    Response<List<GasStationDto>> getGasStationList(@RequestParam(value = "lat", required = false) double lat,
                                                    @RequestParam(value = "lng", required = false) double lng,
                                                    @RequestParam(value = "types", required = false) String[] types,
                                                    @RequestParam(value = "brands", required = false) String[] brands);

    /**
     * 重新刷新对应的编码进redis缓存
     *
     * @return
     */
    @GetMapping("/api/merchant/wx/store/gaslist/refresh")
    Response refreshGasListToCache();

    /**
     * 通过编码列表返回名称，手机号列表
     *
     * @param codes
     * @return
     */
    @GetMapping("/api/merchant/store/accounts/bycodes")
    Response<List<MerchantStoreAccount>> merchantStoreAccountListByAccountCodes(@RequestParam(value = "code") List<String> codes);

    /**
     * 测试事务
     *
     * @return
     */
    @GetMapping("/api/merchant/store/testtx")
    Response testTx();


    /**
     * 商户账号查看权限信息
     * @param accountCode
     * @return
     */
    @GetMapping("/api/merchant/account/getPermissionListByAccountCode")
    Response<List<MerchantStoreAccountPermission>> getPermissionListByAccountCode(@RequestParam(value = "accountCode", required = false) String accountCode);
    /*********************************************   liangyongtong 商户相关 end   ********************************************************************/

    /*********************************************  liangyongtong 商户类型相关 Start   ****************************************************************/
    /**
     * 分页查询商户类型.
     *
     * @param name   商户类型名称(模糊匹配)
     * @param code   商户类型编码(模糊匹配)
     * @param status 商户类型状态
     * @param page   the page
     * @param limit  the limit
     * @return the prefecture tree
     */
    @GetMapping("/api/merchant/type/pageQuery")
    PageTable<MerchantType> merchantTypePageQuery(@RequestParam(value = "name", required = false) String name,
                                                  @RequestParam(value = "code", required = false) String code,
                                                  @RequestParam(value = "status", required = false) String status,
                                                  @RequestParam(value = "page", defaultValue = "1") Integer page,
                                                  @RequestParam(value = "limit", defaultValue = "20") Integer limit);

    /**
     * 查询商户类型.
     *
     * @param name         名称(精准匹配)
     * @param code         编码(精准匹配)
     * @param industryCode 行业编码(精准匹配)
     * @param status       the status
     * @return the response
     */
    @GetMapping("/api/merchant/type/list")
    Response<List<MerchantType>> listMerchantType(@RequestParam(value = "name", required = false) String name,
                                                  @RequestParam(value = "code", required = false) String code,
                                                  @RequestParam(value = "industryCode", required = false) String industryCode,
                                                  @RequestParam(value = "status", required = false, defaultValue = "OPEN") String status);

    /**
     * 根据id查询商户类型.
     *
     * @param id the id
     * @return the by id
     */
    @GetMapping("/api/merchant/type/{id}")
    Response<MerchantType> getMerchantTypeById(@PathVariable("id") Integer id);

    /**
     * 新增或者更新商户类型信息(对象的id属性为空时代表新增).
     *
     * @param merchantType 商户类型对象 {@link MerchantType}
     * @return the response
     */
    @PostMapping("/api/merchant/type")
    Response saveOrUpdateMerchantType(@RequestBody MerchantType merchantType);

    /*********************************************   liangyongtong商户类型相关 end   ********************************************************************/

    /*********************************************  yinshihao 商户品牌相关 Start   ****************************************************************/
    /**
     * 查询商户品牌列表(分页)
     *
     * @param code             品牌名
     * @param keyword          所属行业编码
     * @param status           品牌状态
     * @param industryCodeList 行业编码
     * @param page             页码
     * @param limit            每页条数
     * @return
     */
    @GetMapping("/api/merchant/brand")
    PageTable<MerchantBrand> findMerchantBrandList(@RequestParam(value = "code", required = false) String code,
                                                   @RequestParam(value = "keyword", required = false) String keyword,
                                                   @RequestParam(value = "status", required = false) String status,
                                                   @RequestParam(value = "industryCodeList", required = false) List<String> industryCodeList,
                                                   @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                   @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 新增或编辑商户品牌
     *
     * @param merchantBrand 商户品牌
     * @return
     */
    @PostMapping("/api/merchant/brand/saveOrUpdateMerchantBrand")
    Response saveOrUpdateMerchantBrand(@RequestBody MerchantBrand merchantBrand);

    /**
     * 添加商户品牌对应的行业
     *
     * @param merchantBrand 商户品牌
     * @return
     */
    @PostMapping("/api/merchant/brand/addBrandIndustry")
    Response addBrandIndustry(@RequestBody MerchantBrand merchantBrand);

    /**
     * 改变商户品牌状态
     *
     * @param merchantBrand 商户品牌
     * @return
     */
    @PostMapping("/api/merchant/brand/status")
    Response switchMerchantBrandStatus(@RequestBody MerchantBrand merchantBrand);

    /**
     * 根据id查询商户品牌信息
     *
     * @param id 商户品牌id
     * @return
     */
    @GetMapping("/api/merchant/brand/{id}")
    Response<MerchantBrand> getMerchantBrandById(@PathVariable("id") Integer id);

    /**
     * 根据id查询商户品牌全部信息(包括对应行业信息)
     *
     * @param id 品牌id
     * @return
     */
    @GetMapping("/api/merchant/brand/getAllInfoById/{id}")
    Response<MerchantBrand> getMerchantBrandAllInfoById(@PathVariable("id") Integer id);

    /**
     * 根据商户品牌编号删除专区信息
     *
     * @param name             品牌名称
     * @param brandCode        品牌编码
     * @param industryCodeList 专区编码
     * @return
     */
    @GetMapping("/api/merchant/brand/deleteIndustryByCode")
    Response deleteIndustryByCode(@RequestParam("name") String name, @RequestParam("brandCode") String brandCode, @RequestParam("industryCodeList") List<String> industryCodeList);

    /**
     * 获取启用的品牌列表
     *
     * @param industryCode 行业编码
     * @return
     */
    @GetMapping("/api/merchant/brand/listwithopen")
    Response<List<MerchantBrand>> getMerchantBrandListWithOpen(@RequestParam(value = "industryCode", required = false) String industryCode);

    /*********************************************   yinshihao 商户品牌 end   ********************************************************************/

    /*********************************************  yinshihao 商户行业相关 Start   ****************************************************************/
    /**
     * 商户行业列表(分页)
     *
     * @param keyword 行业名或简称
     * @param code    行业编码
     * @param page    页码
     * @param limit   每页条数
     * @return
     */
    @GetMapping("/api/merchant/industry")
    PageTable<MerchantIndustry> findMerchantIndustryList(@RequestParam(value = "keyword", required = false) String keyword,
                                                         @RequestParam(value = "code", required = false) String code,
                                                         @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                         @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 新增或编辑商户行业
     *
     * @param merchantIndustry 商户行业
     * @return
     */
    @PostMapping("/api/merchant/industry/saveOrUpdateMerchantIndustry")
    Response saveOrUpdateMerchantIndustry(@RequestBody MerchantIndustry merchantIndustry);

    /**
     * 根据id查询商户行业信息
     *
     * @param id 商户行业id
     * @return
     */
    @GetMapping("/api/merchant/industry/{id}")
    Response<MerchantIndustry> getMerchantIndustryById(@PathVariable("id") Integer id);

    /**
     * 根据code查询行业信息
     *
     * @param code 行业code
     * @return
     */
    @GetMapping("/api/merchant/industry/getByCode/{code}")
    Response<MerchantIndustry> getMerchantIndustryByCode(@PathVariable("code") String code);

    /**
     * 根据商户品牌编号查询对应专区编码
     *
     * @param brandCode    品牌编码
     * @param industryCode 行业编码
     * @param keyword      行业名称或简称
     * @return
     */
    @GetMapping("/api/merchant/industry/getIndustryByBrandCode")
    Response<List<MerchantIndustry>> getIndustryByBrandCode(@RequestParam("brandCode") String brandCode,
                                                            @RequestParam(value = "industryCode", required = false) String industryCode,
                                                            @RequestParam(value = "keyword", required = false) String keyword);

    /**
     * 根据服务分类编码查询其所有所属行业.
     *
     * @param serviceClassificationCode 服务分类编码
     * @return the response
     */
    @GetMapping("/api/merchant/industry/listByServiceClassificationCode")
    Response<List<MerchantIndustry>> listByServiceClassificationCode(@RequestParam("serviceClassificationCode") String serviceClassificationCode);

    /**
     * 商户行业列表(服务分类页面使用，用于查询某服务分类未关联的行业)
     *
     * @param serviceClassificationCode 服务分类编码
     * @param industryCodeList          行业编码列表(not in)
     * @param keyword                   行业名或简称
     * @param code                      行业编码
     * @param page                      页码
     * @param limit                     每页条数
     * @return
     */
    @GetMapping("/api/merchant/industry/classificationSearchScrollPage")
    PageTable<MerchantIndustry> classificationSearchScrollPage(@RequestParam(value = "serviceClassificationCode", required = false) String serviceClassificationCode,
                                                               @RequestParam(value = "industryCodeList[]", required = false) List<String> industryCodeList,
                                                               @RequestParam(value = "keyword", required = false) String keyword,
                                                               @RequestParam(value = "code", required = false) String code,
                                                               @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                               @RequestParam(value = "page", defaultValue = "1") int page);
    /*********************************************   yinshihao 商户行业相关 end   ********************************************************************/

    /*********************************************  yinshihao 商户标签相关 Start   ****************************************************************/

    /**
     * 商户标签列表
     *
     * @param name           标签名
     * @param prefectureCode 所属行业编码
     * @param status         标签状态
     * @param page           页码
     * @param limit          每页条数
     * @return
     */
    @GetMapping("/api/merchant/label")
    PageTable<MerchantLabel> findMerchantLabelList(@RequestParam(value = "name", required = false) String name,
                                                   @RequestParam(value = "prefectureCode", required = false) String prefectureCode,
                                                   @RequestParam(value = "status", required = false) String status,
                                                   @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                   @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 新增或编辑商户标签
     *
     * @param merchantLabel
     * @return
     */
    @PostMapping("/api/merchant/label/saveOrUpdateMerchantLabel")
    Response saveOrUpdateMerchantLabel(@RequestBody MerchantLabel merchantLabel);

    /**
     * 添加标签对应专区
     *
     * @param merchantLabel
     * @return
     */
    @PostMapping("/api/merchant/label/addLabelPrefecture")
    Response addLabelPrefecture(@RequestBody MerchantLabel merchantLabel);

    /**
     * 商户标签状态改变
     *
     * @param merchantLabel 商户标签
     * @return
     */
    @PostMapping("/api/merchant/label/status")
    Response switchMerchantLabelStatus(@RequestBody MerchantLabel merchantLabel);

    /**
     * 根据id查询商户标签信息
     *
     * @param id 商户标签id
     * @return
     */
    @GetMapping("/api/merchant/label/{id}")
    Response<MerchantLabel> getMerchantLabelById(@PathVariable("id") Integer id);

    /**
     * 根据商户标签编号查询对应专区编码
     *
     * @param labelCode      标签编码
     * @param prefectureCode 专区编码
     * @param prefectureName 专区名称
     * @return
     */
    @GetMapping("/api/merchant/label/getPrefectureByLabelCode")
    Response<List<String>> getPrefectureByLabelCode(@RequestParam("labelCode") String labelCode,
                                                    @RequestParam(value = "prefectureCode", required = false) String prefectureCode,
                                                    @RequestParam(value = "prefectureName", required = false) String prefectureName);

    /**
     * 根据code查询标签信息
     *
     * @param code 标签code
     * @return
     */
    @GetMapping("/api/merchant/label/getMerchantLabelByCode/{code}")
    Response<MerchantLabel> getMerchantLabelByCode(@PathVariable("code") String code);

    /**
     * 根据商户标签编号删除专区信息
     *
     * @param labelCode          标签编码
     * @param prefectureCodeList 专区编码
     * @return
     */
    @GetMapping("/api/merchant/label/deletePrefectureByCode")
    Response deletePrefectureByCode(@RequestParam("labelCode") String labelCode, @RequestParam("prefectureCodeList") List<String> prefectureCodeList);
    /*********************************************   yinshihao 商户标签相关 end   ********************************************************************/

    /*********************************************  ranxiangfu 服务分类和行业对应相关 Start   ****************************************************************/

    /**
     * 根据服务分类编码获取所属行业列表.
     *
     * @param serviceClassificationCode 服务分类编码
     * @return the response
     */
    @GetMapping("/api/merchant/service-classification-industry/listByServiceClassificationCode")
    Response<List<ServiceClassificationIndustry>> listServiceClassificationIndustryByCode(@RequestParam("serviceClassificationCode") String serviceClassificationCode);

    /**
     * 新增服务分类所属行业.
     *
     * @param serviceClassificationIndustry 服务分类所属行业对象 {@link com.rocogz.merchant.entity.service.ServiceClassificationIndustry}
     * @return the response
     */
    @PostMapping("/api/merchant/service-classification-industry")
    Response addServiceClassificationIndustry(@RequestBody ServiceClassificationIndustry serviceClassificationIndustry);

    /**
     * 批量新增服务分类所属行业.
     *
     * @param serviceClassificationIndustryList 服务分类所属行业对象列表 {@link com.rocogz.merchant.entity.service.ServiceClassificationIndustry}
     * @return the response
     */
    @PostMapping("/api/merchant/service-classification-industry/saveBatch")
    Response saveBatchServiceClassificationIndustry(@RequestBody List<ServiceClassificationIndustry> serviceClassificationIndustryList);

    /**
     * 根据id删除服务分类所属行业.
     *
     * @param id the id
     * @return the response
     */
    @DeleteMapping("/api/merchant/service-classification-industry")
    Response removeServiceClassificationIndustry(@RequestParam("id") Integer id);

    /**
     * 根据id删除服务分类所属行业.
     *
     * @param serviceClassificationCode 服务分类编码
     * @param industryCode              行业编码
     * @return the response
     */
    @DeleteMapping("/api/merchant/service-classification-industry/removeByCode")
    Response removeServiceClassificationIndustryByCode(@RequestParam("serviceClassificationCode") String serviceClassificationCode,
                                                       @RequestParam("industryCode") String industryCode);
    /*********************************************   ranxiangfu 服务分类和行业相关 end   ********************************************************************/

    /*********************************************  ranxiangfu 服务分类相关 Start   ****************************************************************/

    /**
     * 分页查询服务分类.
     *
     * @param page  the page
     * @param limit the limit
     * @return the prefecture tree
     */
    @GetMapping("/api/merchant/service-classification/pageQuery")
    PageTable<ServiceClassification> pageQueryServiceClassification(@RequestParam(value = "page", defaultValue = "1") Integer page,
                                                                    @RequestParam(value = "limit", defaultValue = "20") Integer limit);

    /**
     * 获取服务分类树.
     *
     * @return the prefecture tree
     */
    @GetMapping("/api/merchant/service-classification/getTree")
    Response<List<TreeDto<ServiceClassification>>> getServiceClassificationTree();

    /**
     * 根据id查询服务分类.
     *
     * @param id the id
     * @return the by id
     */
    @GetMapping("/api/merchant/service-classification/{id}")
    Response<ServiceClassification> getServiceClassificationById(@PathVariable("id") Integer id);

    /**
     * 根据编码查询服务分类.
     *
     * @param code 服务分类编码
     * @return the by id
     */
    @GetMapping("/api/merchant/service-classification/getByCode")
    Response<ServiceClassification> getServiceClassificationByCode(@RequestParam("code") String code);

    /**
     * 新增或者更新服务分类信息(对象的id属性为空时代表新增).
     *
     * @param serviceClassification 专区对象 {@link com.rocogz.merchant.entity.service.ServiceClassification}
     * @return the response
     */
    @PostMapping("/api/merchant/service-classification")
    Response saveOrUpdateServiceClassification(@RequestBody ServiceClassification serviceClassification);
    /*********************************************   ranxiangfu 服务分类相关 end   ********************************************************************/

    /*********************************************  liangyongtong 专区服务相关 Start   ****************************************************************/
    /**
     * 保存更新专区服务项目
     *
     * @param areaService 专区服务项目对象
     * @return
     */
    @PostMapping("/api/merchant/areaservice")
    Response merchantAreaServiceSave(@RequestBody MerchantAreaService areaService);

    /**
     * 专区服务项目列表查询
     *
     * @param keyword           名称
     * @param code              编码
     * @param cataCode          服务分类编码
     * @param areaCodes         专区编码列表
     * @param nature            范围
     * @param status            状态
     * @param noRepeatStoreCode 商户编码，添加该商户的服务项目的时候选择的专区服务项目非套餐的情况下不能重复
     * @param limit             每页条数
     * @param page              页码
     * @return
     */
    @GetMapping("/api/merchant/areaservice/queryPage")
    PageTable<MerchantAreaService> merchantAreaServicePageTable(@RequestParam(required = false, value = "keyword") String keyword,
                                                                @RequestParam(required = false, value = "code") String code,
                                                                @RequestParam(required = false, value = "cataCode") String cataCode,
                                                                @RequestParam(required = false, value = "areaCodes") String[] areaCodes,
                                                                @RequestParam(required = false, value = "nature") String nature,
                                                                @RequestParam(required = false, value = "status") String status,
                                                                @RequestParam(required = false, value = "noRepeatStoreCode") String noRepeatStoreCode,
                                                                @RequestParam(required = false, value = "settleCode") String[] settleCode,
                                                                @RequestParam(required = false, value = "limit", defaultValue = "20") int limit,
                                                                @RequestParam(required = false, value = "page", defaultValue = "1") int page);

    /**
     * 通过专区服务项目编码获取专区服务项目详情
     *
     * @param code 专区服务编码
     * @return
     */
    @GetMapping("/api/merchant/areaservice/detailbycode")
    Response<MerchantAreaService> merchantAreaServiceDetailByCode(@RequestParam(value = "code") String code);

    /**
     * 更新专区服务项目的状态
     *
     * @param code        专区服务项目编码
     * @param status      目标状态
     * @param operateUser 操作人
     * @return
     */
    @GetMapping("/api/merchant/areaservice/operate/status")
    Response merchantAreaServiceOperateStatus(@RequestParam(value = "code") String code, @RequestParam(value = "status") String status, @RequestParam(value = "operateUser") String operateUser);

    /**
     * 查询专区服务项目基本信息
     *
     * @param codes 专区服务项目编码列表 最多200个
     * @return 专区服务项目列表
     */
    @GetMapping("/api/merchant/areaservice/list/servicesByCodes")
    Response<List<MerchantAreaService>> merchantAreaServiceBaseInfoByCodes(@RequestParam(value = "codes") String[] codes);

    /**
     * 保存专区服务结算信息
     *
     * @param settlement 结算对象
     * @return
     */
    @PostMapping("/api/merchant/areaservice/settle/save")
    Response merchantAreaServiceSettleSave(@RequestBody MerchantAreaServiceSettlement settlement);

    /**
     * 获取结算信息详情
     *
     * @param settlementCode 结算信息编码
     * @return
     */
    @GetMapping("/api/merchant/areaservice/settle/detail")
    Response<MerchantAreaServiceSettlement> merchantAreaServiceSettlementDetailBySettlementCode(@RequestParam(value = "settlementCode") String settlementCode);

    /**
     * 获取专区服务项目对应的结算列表
     *
     * @param code 专区服务项目编码
     * @return
     */
    @GetMapping("/api/merchant/areaservice/settle/list")
    Response<List<MerchantAreaServiceSettlement>> merchantAreaServiceSettlementListByAreaServiceCode(@RequestParam(value = "code") String code);

    /**
     * 删除结算信息对象
     *
     * @param code 结算信息对象编码
     * @return
     */
    @GetMapping("/api/merchant/areaservice/settle/remove")
    Response merchentAreaServiceSettlementRemoveBySettlementCode(@RequestParam(value = "code") String code);

    /**
     * 通过专区项目编码查询可关联的专区和结算商的数据
     *
     * @param code       专区服务项目编码
     * @param areaCode   专区编码
     * @param settleCode 结算商编码
     * @return
     */
    @GetMapping("/api/merchant/areaservice/settle/pricelist")
    Response<MerchantAreaServiceSettlement> merchantAreaServiceSettlementByAreaCodeAndSettleCode(@RequestParam(value = "code") String code, @RequestParam(value = "areaCode") String areaCode, @RequestParam(value = "settleCode") String settleCode);

    /*********************************************   liangyongtong 专区服务相关 end   ********************************************************************/

    /*********************************************  liangyongtong 商户服务相关 Start   ****************************************************************/
    /**
     * 更新保存商户服务项目
     *
     * @param storeService 商户服务项目对象
     * @return
     */
    @PostMapping("/api/merchant/storeservice")
    Response merchantStoreServiceSave(@RequestBody MerchantStoreService storeService);

    /**
     * 商户服务项目列表查询 (关联商户表)
     *
     * @param keyword      名称
     * @param code         编码
     * @param excludedCode 不包含编码
     * @param cataCode     服务分类编码
     * @param areaCodes    专区编码列表
     * @param storeCodes   商户编码列表
     * @param status       状态
     * @param distinguish  是否车型
     * @param combo        是否套餐
     * @param limit        每页条数
     * @param page         页码
     * @return
     */
    @GetMapping("/api/merchant/storeservice/queryPage")
    PageTable<MerchantStoreService> merchantStoreServicePageTable(@RequestParam(value = "keyword", required = false) String keyword,
                                                                  @RequestParam(value = "code", required = false) String code,
                                                                  @RequestParam(value = "excludedCode", required = false) String[] excludedCode,
                                                                  @RequestParam(value = "cataCode", required = false) String cataCode,
                                                                  @RequestParam(value = "areaCodes", required = false) String[] areaCodes,
                                                                  @RequestParam(value = "storeCodes", required = false) String[] storeCodes,
                                                                  @RequestParam(value = "status", required = false) String status,
                                                                  @RequestParam(name = "settleSubjectList", required = false) List<String> settleSubjectList,
                                                                  @RequestParam(value = "distinguish", required = false) String distinguish,
                                                                  @RequestParam(value = "combo", required = false) String combo,
                                                                  @RequestParam(value = "limit", required = false, defaultValue = "20") int limit,
                                                                  @RequestParam(value = "page", required = false, defaultValue = "1") int page);

    @GetMapping("/api/merchant/storeservice/queryByCodes")
    List<MerchantStoreService> queryMerchantStoreServiceByCodes(@RequestParam(value = "includedCode") List<String> includedCode, @RequestParam(value = "combo", required = false) String combo);

    /**
     * 商户服务项目列表查询 (只查询商户服务项目表)
     *
     * @param keyword      名称
     * @param code         编码
     * @param excludedCode 不包含编码
     * @param cataCode     服务分类编码
     * @param storeCode    商户编码
     * @param status       状态
     * @param limit        每页条数
     * @param page         页码
     * @return
     */
    @GetMapping("/api/merchant/storeservice/base/queryPage")
    PageTable<MerchantStoreService> merchantStoreServiceBaseInfoPageTable(@RequestParam(value = "keyword", required = false) String keyword,
                                                                          @RequestParam(value = "code", required = false) String code,
                                                                          @RequestParam(value = "excludedCode", required = false) String excludedCode,
                                                                          @RequestParam(value = "cataCode", required = false) String cataCode,
                                                                          @RequestParam(value = "storeCode", required = false) String storeCode,
                                                                          @RequestParam(value = "status", required = false, defaultValue = Constant.DictData.MERCHANT_STORE_STATUS_UP_LIST) String status,
                                                                          @RequestParam(value = "limit", required = false, defaultValue = "20") int limit,
                                                                          @RequestParam(value = "page", required = false, defaultValue = "1") int page);

    /**
     * 批量操作状态上架下架
     *
     * @param codes       待操作的商户服务项目编码列表
     * @param status      目标状态
     * @param operateUser 操作人
     * @return
     */
    @GetMapping("/api/merchant/storeservice/batch/status")
    Response merchantStoreServiceBatchOperateStatus(@RequestParam(value = "codes") String[] codes, @RequestParam(value = "status") String status, @RequestParam(value = "operateUser") String operateUser);

    /**
     * 操作商户服务项目的状态
     *
     * @param code        待操作的商户服务项目编码
     * @param status      目标状态
     * @param operateUser 操作人
     * @return
     */
    @GetMapping("/api/merchant/storeservice/operate/status")
    Response merchantStoreServiceOperateStatus(@RequestParam(value = "code") String code, @RequestParam(value = "status") String status, @RequestParam(value = "operateUser") String operateUser);

    /**
     * 删除草稿状态的商户服务项目
     *
     * @param code 待删除的商户服务项目编码
     * @return
     */
    @GetMapping("/api/merchant/storeservice/remove")
    Response merchantStoreServiceRemoveByCode(@RequestParam(value = "code") String code);

    /**
     * 获取商户服务项目详情信息
     *
     * @param code 商户服务项目编码
     * @returnmerchantStoreServiceBaseInfoPageTable
     */
    @GetMapping("/api/merchant/storeservice/detail")
    Response<MerchantStoreService> merchantStoreServiceDetailByCode(@RequestParam(value = "code") String code);

    /**
     * 查询商户下的服务列表（不分页，不含结算信息)
     *
     * @param storeCode 商户编码
     * @param status    状态 （默认为上架，传 "")
     * @return 服务列表
     */
    @GetMapping("/api/merchant/storeservice/nopagelist")
    Response<List<MerchantStoreService>> merchantStoreServiceListByStoreCode(@RequestParam(value = "storeCode") String storeCode, @RequestParam(value = "status", required = false, defaultValue = Constant.DictData.MERCHANT_STORE_STATUS_UP_LIST) String status);

    /**
     * 查询商户下服务项目基本信息
     *
     * @param storeCode 商户编码
     * @param codes     服务项目编码列表
     * @return 服务项目列表
     */
    @GetMapping("/api/merchant/storeservice/store/services")
    Response<List<MerchantStoreService>> merchantStoreServiceBaseInfoByStoreCodeAndCodes(@RequestParam(value = "storeCode") String storeCode,
                                                                                         @RequestParam(value = "codes") String[] codes);

    /**
     * 返回该商户服务项目下对应车型的价格
     *
     * @param storeServiceCode 商户服务项目编码
     * @param carType          车型
     * @return 价格对象
     */
    @GetMapping("/api/merchant/storeservice/store/service/price")
    Response<MerchantStoreServicePrice> merchantStoreServicePriceByStoreServiceCodeAndCarType(@RequestParam(value = "storeServiceCode") String storeServiceCode, @RequestParam(value = "carType") String carType);

    /**
     * 查询服务项目基本信息
     *
     * @param codes 服务项目编码列表 最多200个
     * @return 服务项目列表
     */
    @GetMapping("/api/merchant/storeservice/store/servicesByCodes")
    Response<List<MerchantStoreService>> merchantStoreServiceBaseInfoByCodes(@RequestParam(value = "codes") String[] codes);

    /**
     * 对商户服务进行排序
     *
     * @param code   商户服务项目编码
     * @param newSeq 新的排序号
     * @return
     */
    @GetMapping("/api/merchant/storeservice/seq")
    Response merchantStoreServviceSeq(@RequestParam(value = "code") String code, @RequestParam(value = "newSeq") int newSeq);

    /**
     * 查询服务项目操作日志列表
     *
     * @param storeServiceCode 商户服务项目编码
     * @param limit            每页数量
     * @param page             当前页
     * @return 列表
     */
    @GetMapping("/api/merchant/storeservice/ulog/queryPage")
    PageTable<MerchantStoreServiceUlog> merchantStoreServiceUlogPageTable(@RequestParam(value = "storeServiceCode") String storeServiceCode,
                                                                          @RequestParam(required = false, defaultValue = "20", value = "limit") int limit,
                                                                          @RequestParam(required = false, defaultValue = "1", value = "page") int page);

    /**
     * 新增或保存预约数据
     *
     * @param storeService
     * @return
     */
    @PostMapping("/api/merchant/storeservice/appointment/saveorupdate")
    Response merchantStoreServiceAppointmentSaveOrUpdate(@RequestBody MerchantStoreService storeService);

    /**
     * 通过商户服务项目编码获取对应的预约数据
     *
     * @param storeServiceCode 商户服务项目编码
     * @return
     */
    @GetMapping("/api/merchant/storeservice/appointment/listByStoreServiceCode")
    Response<List<MerchantStoreServiceAppointment>> merchantStoreServiceAppointmentByStoreServiceCode(@RequestParam(value = "storeServiceCode") String storeServiceCode);

    /**
     * 通过商户编码获取该商户下第一个开启了预约设置的商户服务项目对应的预约数据
     *
     * @param storeCode 商户编码
     * @return
     */
    @GetMapping("/api/merchant/storeservice/appointment/listByStoreCode")
    Response<List<MerchantStoreServiceAppointment>> merchantStoreServiceAppointmentByStoreCode(@RequestParam(value = "storeCode") String storeCode);

    /**
     * 通过商户编码获取该商户下第一个开启了预约设置的商户服务项目
     *
     * @param storeCode 商户编码
     * @return
     */
    @GetMapping("/api/merchant/storeservice/appointment/serviceItemByStoreCode")
    Response<MerchantStoreService> merchantStoreServiceAppointmentItemByStoreCode(@RequestParam(value = "storeCode") String storeCode);

    /**
     * 通过服务项目编码列表查询对应的套餐数据
     *
     * @param storeServiceComboCodes 商户服务项目编码列表
     * @return
     */
    @PostMapping("/api/merchant/storeservice/storeservicecombo")
    Response<Map<String, List<MerchantStoreService>>> merchantStoreServiceComboData(@RequestBody List<String> storeServiceComboCodes);

    /*********************************************   liangyongtong 商户服务相关 end   ********************************************************************/

    /*********************************************   liangyongtong 商户服务标签 start   ********************************************************************/
    /**
     * 新增或更新商户服务标签
     *
     * @param label
     * @return
     */
    @PostMapping("/api/merchant/storeservice/label/saveOrUpdate")
    Response merchantStoreServiceLabelSaveOrUpdate(@RequestBody MerchantStoreServiceLabel label);

    /**
     * 查询商户服务项目标签列表
     *
     * @param keyword 标签名称关键字
     * @param status  状态
     * @param limit   每页长度
     * @param page    当前页
     * @return
     */
    @GetMapping("/api/merchant/storeservice/label/queryPage")
    PageTable<MerchantStoreServiceLabel> merchantStoreServiceLabelPageTable(@RequestParam(value = "keyword", required = false) String keyword,
                                                                            @RequestParam(value = "status", required = false) String status,
                                                                            @RequestParam(value = "limit", required = false, defaultValue = "20") int limit,
                                                                            @RequestParam(value = "page", required = false, defaultValue = "1") int page);

    /**
     * 变更标签的状态
     *
     * @param id          标签id
     * @param status      目标状态
     * @param operateUser 操作人
     * @return
     */
    @GetMapping("/api/merchant/storeservice/label/operateStatus")
    Response merchantStoreServiceLabelOperateStatus(@RequestParam(value = "id") Integer id, @RequestParam(value = "status") String status, @RequestParam(value = "operateUser") String operateUser);
    /*********************************************   liangyongtong 商户服务标签 end   ********************************************************************/

    /*********************************************   liangyongtong 评价结果保存 start   ********************************************************************/
    /**
     * 更新商户、商户服务项目平均分，记录印象标签统计数量
     *
     * @param evaluate 评价结果
     * @return
     */
    @PostMapping("/api/merchant/evaluate/kpi/all")
    Response evaluateKpiAll(@RequestBody EvaluateDto evaluate);

    /**
     * 更新商户、商户服务项目订单数
     *
     * @param evaluate 记录结果
     * @return
     */
    @PostMapping("/api/merchant/evaluate/kpi/store")
    Response evaluateKpiForStore(@RequestBody EvaluateDto evaluate);

    /**
     * 获取商户服务项目的印象标签
     *
     * @param storeServiceCode 商户服务项目编码
     * @return 针对该商户服务项目的印象标签统计列表
     */
    @GetMapping("/api/merchant/evaluate/kpi/storeservice/impression")
    Response<List<MerchantEvaluateKpi>> merchantEvaluateKpiWithStoreService(@RequestParam(value = "storeServiceCode") String storeServiceCode);

    /**
     * 获取商户的印象标签
     *
     * @param storeCode 商户编码
     * @return 针对该商户的印象标签统计列表
     */
    @GetMapping("/api/merchant/evaluate/kpi/store/impression")
    Response<List<MerchantEvaluateKpi>> merchantEvaluateKpiWithStore(@RequestParam(value = "storeCode") String storeCode);

    /**
     * 设置评价印象标签数量
     *
     * @param storeServiceCode 商户服务项目编码
     * @param type             com.rocogz.merchant.constant.Constant.General#MERCHANTEVALUATEKPI_ADD,
     *                         com.rocogz.merchant.constant.Constant.General#MERCHANTEVALUATEKPI_CANCEL,
     *                         com.rocogz.merchant.constant.Constant.General#MERCHANTEVALUATEKPI_DELETE,
     *                         *             com.rocogz.merchant.constant.Constant.General#MERCHANTEVALUATEKPI_HIDE,
     *                         *             com.rocogz.merchant.constant.Constant.General#MERCHANTEVALUATEKPI_SHOW
     * @param impressinos      印象标签数组
     * @param perfect          是否精选
     * @return
     */
    @GetMapping("/api/merchant/evaluate/kpi/storeservice/kpioperateamount")
    Response merchantEvaluateKpiOperateAmount(@RequestParam(value = "storeServiceCode") String storeServiceCode, @RequestParam(value = "type") String type, @RequestParam(value = "impressinos") String[] impressinos, @RequestParam(value = "perfect", required = false) Boolean perfect);
    /*********************************************   liangyongtong 评价结果保存 end   ********************************************************************/

    /*********************************************  liangyongtong 车主商户端商户相关 Start   ****************************************************************/
    /**
     * 查询商户列表数据（含基本表数据，停业信息，标签）【每次最多1000个】
     *
     * @param codes  商户编码列表
     * @param status 目标查询状态
     * @return
     */
    @GetMapping("/api/merchant/wx/store/list/bycodes")
    Response<List<MerchantStore>> getMerchantStoreListByCodes(@RequestParam(value = "codes") String[] codes, @RequestParam(value = "status", required = false) String status);

    /**
     * 查询商户列表数据（主要针对会员端商户列表）
     *
     * @param areaCode          专区编码
     * @param keyword           关键字
     * @param provinceCode      省编码
     * @param cityCode          市编码
     * @param districtCode      区编码
     * @param streetCode        街道编码
     * @param industryCode      行业编码
     * @param serviceType       服务类型
     * @param storeTypes        商户类型
     * @param orderType         排序类型
     * @param lat               纬度
     * @param lng               经度
     * @param areaServiceCode   专区服务项目编码
     * @param includeStoreCodes 包含的商户编码列表
     * @param excludeStoreCodes 不包含的商户编码列表
     * @param limit             每页数量
     * @param page              页码
     * @return
     */
    @GetMapping("/api/merchant/wx/store/list")
    PageTable<MerchantStore> getMerchantStoreCarList(@RequestParam(value = "areaCode", required = false) String areaCode,
                                                     @RequestParam(value = "keyword", required = false) String keyword,
                                                     @RequestParam(value = "provinceCode", required = false) String provinceCode,
                                                     @RequestParam(value = "cityCode", required = false) String cityCode,
                                                     @RequestParam(value = "districtCode", required = false) String districtCode,
                                                     @RequestParam(value = "streetCode", required = false) String streetCode,
                                                     @RequestParam(value = "industryCode", required = false) String industryCode,
                                                     @RequestParam(value = "serviceType", required = false) String serviceType,
                                                     @RequestParam(value = "storeTypes", required = false) String[] storeTypes,
                                                     @RequestParam(value = "orderType", required = false) String orderType,
                                                     @RequestParam(value = "lat", required = false, defaultValue = "0") double lat,
                                                     @RequestParam(value = "lng", required = false, defaultValue = "0") double lng,
                                                     @RequestParam(value = "areaServiceCode", required = false) String areaServiceCode,
                                                     @RequestParam(value = "includeStoreCodes", required = false) String[] includeStoreCodes,
                                                     @RequestParam(value = "excludeStoreCodes", required = false) String[] excludeStoreCodes,
                                                     @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                     @RequestParam(value = "page", defaultValue = "1") int page
    );

    /**
     * 查询商户列表数据（主要针对会员端地图模式商户列表）
     *
     * @param areaCode          专区编码
     * @param keyword           关键字
     * @param provinceCode      省编码
     * @param cityCode          市编码
     * @param districtCode      区编码
     * @param streetCode        街道编码
     * @param industryCode      行业编码
     * @param serviceType       服务类型
     * @param storeTypes        商户类型
     * @param lat               纬度
     * @param lng               经度
     * @param areaServiceCode   专区服务项目编码
     * @param includeStoreCodes 包含的商户编码列表
     * @param excludeStoreCodes 不包含的商户编码列表
     * @return
     */
    @GetMapping("/api/merchant/wx/store/nearlist")
    Response<List<MerchantStore>> getMerchantNearStoreCarList(@RequestParam(value = "areaCode", required = false) String areaCode,
                                                              @RequestParam(value = "keyword", required = false) String keyword,
                                                              @RequestParam(value = "provinceCode", required = false) String provinceCode,
                                                              @RequestParam(value = "cityCode", required = false) String cityCode,
                                                              @RequestParam(value = "districtCode", required = false) String districtCode,
                                                              @RequestParam(value = "streetCode", required = false) String streetCode,
                                                              @RequestParam(value = "industryCode", required = false) String industryCode,
                                                              @RequestParam(value = "serviceType", required = false) String serviceType,
                                                              @RequestParam(value = "storeTypes", required = false) String[] storeTypes,
                                                              @RequestParam(value = "lat", required = false, defaultValue = "0") double lat,
                                                              @RequestParam(value = "lng", required = false, defaultValue = "0") double lng,
                                                              @RequestParam(value = "areaServiceCode", required = false) String areaServiceCode,
                                                              @RequestParam(value = "includeStoreCodes", required = false) String[] includeStoreCodes,
                                                              @RequestParam(value = "excludeStoreCodes", required = false) String[] excludeStoreCodes
    );

    /**
     * 查询专区下各街道的上架商户数
     *
     * @param areaServiceCode   专区服务项目编码
     * @param includeStoreCodes 包含的商户编码列表
     * @param excludeStoreCodes 不包含的商户编码列表
     * @param areaCode          专区编码
     * @return
     */
    @GetMapping("/api/merchant/wx/store/areaStoreCount")
    Response<List<FilterAreaCountDto>> getAreaStoreCount(@RequestParam(value = "areaServiceCode", required = false) String areaServiceCode,
                                                         @RequestParam(value = "includeStoreCodes", required = false) String[] includeStoreCodes,
                                                         @RequestParam(value = "excludeStoreCodes", required = false) String[] excludeStoreCodes,
                                                         @RequestParam(value = "areaCode") String areaCode);

    /**
     * 查询用户券的可用商户数量
     *
     * @param areaServiceCode   专区服务项目编码
     * @param includeStoreCodes 包含的商户编码列表
     * @param excludeStoreCodes 不包含的商户编码列表
     * @param areaCode          专区编码
     * @return 可用商户数
     */
    @GetMapping("/api/merchant/wx/store/usableStoreCount")
    Response<Integer> getUsableStoreCount(@RequestParam(value = "areaServiceCode") String areaServiceCode,
                                          @RequestParam(value = "includeStoreCodes", required = false) String[] includeStoreCodes,
                                          @RequestParam(value = "excludeStoreCodes", required = false) String[] excludeStoreCodes,
                                          @RequestParam(value = "areaCode") String areaCode);

    /**
     * 查询商户下某专区服务项目列表信息
     *
     * @param storeCode       商户编码
     * @param areaServiceCode 专区服务项目编码
     * @param status          服务状态
     * @return 商户服务项目列表
     */
    @GetMapping("/api/merchant/storeservice/store/servicesbyareaservicecode")
    Response<List<MerchantStoreService>> merchantStoreServiceByStoreCodeAndAreaServiceCode(@RequestParam(value = "storeCode") String storeCode,
                                                                                           @RequestParam(value = "areaServiceCode") String areaServiceCode,
                                                                                           @RequestParam(value = "status", required = false) String status);

    /**
     * 通过专区服务项目编码获取对应的评价指标数据
     *
     * @param areaServiceCode 专区服务项目编码
     * @return 只含两个指标维度数据的专区服务项目对象
     */
    @GetMapping("/api/merchant/wx/areaservice/kpi")
    Response<MerchantAreaService> merchantAreaServiceEvaluativeDimension(@RequestParam(value = "areaServiceCode") String areaServiceCode);

    /*********************************************   yinshihao MerchantAreaServiceImpressionLabel start   ********************************************************************/
    /**
     * 新增或更新商户服务标签
     *
     * @param label
     * @return
     */
    @PostMapping("/api/merchant/service/impression/label/saveOrUpdate")
    Response merchantAreaServiceImpressionLabelSaveOrUpdate(@RequestBody MerchantAreaServiceImpressionLabel label);

    /**
     * 查询商户服务项目标签列表
     *
     * @param keyword 标签名称关键字
     * @param status  状态
     * @param limit   每页长度
     * @param page    当前页
     * @return
     */
    @GetMapping("/api/merchant/service/impression/label/queryPage")
    PageTable<MerchantAreaServiceImpressionLabel> merchantAreaServiceImpressionLabelPageTable(@RequestParam(value = "keyword", required = false) String keyword,
                                                                                              @RequestParam(value = "status", required = false) String status,
                                                                                              @RequestParam(value = "limit", required = false, defaultValue = "20") int limit,
                                                                                              @RequestParam(value = "page", required = false, defaultValue = "1") int page);

    /**
     * 变更标签的状态
     *
     * @param id          标签id
     * @param status      目标状态
     * @param operateUser 操作人
     * @return
     */
    @GetMapping("/api/merchant/service/impression/label/operateStatus")
    Response merchantAreaServiceImpressionLabelOperateStatus(@RequestParam(value = "id") Integer id, @RequestParam(value = "status") String status, @RequestParam(value = "operateUser") String operateUser);

    /**
     * 删除标签
     *
     * @param id 标签id
     * @return
     */
    @GetMapping("/api/merchant/service/impression/label/deleteById")
    Response deleteMerchantAreaServiceImpressionLabeById(@RequestParam("id") Integer id);
    /*********************************************   yinshihao MerchantAreaServiceImpressionLabel end   ********************************************************************/

    /*********************************************   yinshihao MerchantGoods start   ********************************************************************/

    /**
     * 更新保存商品
     *
     * @param goods
     * @return
     */
    @PostMapping("/api/merchant/goods/saveMerchantGoods")
    Response<String> saveMerchantGoods(@RequestBody MerchantGoods goods);

    /**
     * 商品列表数据查询
     *
     * @param keyword                 名称 模糊匹配
     * @param code                    编码 全匹配
     * @param erpGoodsCode            erp编码 全匹配
     * @param brandCode               品牌编码 全匹配
     * @param supplierCode            供应商编码 全匹配
     * @param goodsClassificationCode 商品分类编码 全匹配
     * @param status                  商品状态
     * @param invented                是否虚拟商品
     * @param limit                   每页条数
     * @param page                    页码
     * @return
     */
    @GetMapping("/api/merchant/goods/queryPage")
    PageTable<MerchantGoods> merchantGoodsPageTable(@RequestParam(value = "keyword", required = false) String keyword,
                                                    @RequestParam(value = "code", required = false) String code,
                                                    @RequestParam(value = "erpGoodsCode", required = false) String erpGoodsCode,
                                                    @RequestParam(value = "brandCode", required = false) String brandCode,
                                                    @RequestParam(value = "supplierCode", required = false) String supplierCode,
                                                    @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
                                                    @RequestParam(value = "saleType", required = false) String saleType,
                                                    @RequestParam(value = "status", required = false) String status,
                                                    @RequestParam(value = "supplierCodeList", required = false) List<String> supplierCodeList,
                                                    @RequestParam(value = "invented", required = false) String invented,
                                                    @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                    @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 操作商品状态
     *
     * @param code       商品编码
     * @param status     目标商品状态
     * @param updateUser 更新用户
     * @return
     */
    @GetMapping("/api/merchant/goods/operateStatus")
    Response merchantGoodsStatusOperate(@RequestParam(value = "code") String code, @RequestParam(value = "status") String status, @RequestParam(value = "updateUser") String updateUser);

    /**
     * 审批回调更改状态（上架审批后回调）
     *
     * @param pass
     * @param code
     * @param updateUser
     * @return
     */
    @GetMapping("/api/merchant/goods/goodsApproveCallBlack")
    Response goodsApproveCallBlack(@RequestParam(value = "pass") String pass, @RequestParam(value = "code") String code, @RequestParam(value = "updateUser") String updateUser);

    /**
     * 根据商品编码删除商品
     *
     * @param code 商品编码
     * @return
     */
    @GetMapping("/api/merchant/goods/deleteGoods")
    Response merchantGoodsDeleteByCode(@RequestParam(value = "code") String code);

    /**
     * 根据商品编码获取商品详情
     *
     * @param code 商品编码
     * @return
     */
    @GetMapping("/api/merchant/goods/goodsDetail")
    Response<MerchantGoods> merchantGoodsDetailByCode(@RequestParam(value = "code") String code);

    /**
     * 批量操作状态上架下架
     *
     * @param codes       待操作的商户服务项目编码列表
     * @param status      目标状态
     * @param operateUser 操作人
     * @return
     */
    @GetMapping("/api/merchant/goods/batch/status")
    Response merchantGoodsBatchOperateStatus(@RequestParam(value = "codes") String[] codes, @RequestParam(value = "status") String status, @RequestParam(value = "operateUser") String operateUser);

    /**
     * 根据商品分类编码获取商品列表(基本信息)
     *
     * @param goodsClassificationCode 商品分类编码
     * @return
     */
    @GetMapping("/api/merchant/goods/findGoodsListByClassificationCode")
    Response<List<MerchantGoods>> findGoodsListByClassificationCode(@RequestParam("goodsClassificationCode") String goodsClassificationCode);

    /**
     * 商品列表数据查询(去掉兑换商品中已有的商品信息)
     *
     * @param keyword                 名称 模糊匹配
     * @param code                    编码 模糊匹配
     * @param brandCode               品牌编码 全匹配
     * @param goodsClassificationCode 商品分类编码 全匹配
     * @param status                  商品状态
     * @param limit                   每页条数
     * @param page                    页码
     * @return
     */
    @GetMapping("/api/merchant/goods/queryPageNoExchangeGoods")
    PageTable<MerchantGoods> queryPageNoExchangeGoods(@RequestParam(value = "keyword", required = false) String keyword,
                                                      @RequestParam(value = "code", required = false) String code,
                                                      @RequestParam(value = "brandCode", required = false) String brandCode,
                                                      @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
                                                      @RequestParam(value = "saleType", required = false) String saleType,
                                                      @RequestParam(value = "goodsType", required = false) String goodsType,
                                                      @RequestParam(value = "status", required = false) String status,
                                                      @RequestParam(value = "supplierCodeList", required = false) List<String> supplierCodeList,
                                                      @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                      @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 商品列表数据查询(若传了noGoodsCodeList,则是去掉noGoodsCodeList中的商品信息)
     *
     * @param keyword                 名称 模糊匹配
     * @param code                    编码 模糊匹配
     * @param noGoodsCodeList         不需要查询的编码列表
     * @param brandCode               品牌编码 全匹配
     * @param goodsClassificationCode 商品分类编码 全匹配
     * @param status                  商品状态
     * @param queryType               查询类型
     * @param limit                   每页条数
     * @param page                    页码
     * @return
     */
    @GetMapping("/api/merchant/goods/queryPageNoGoods")
    PageTable<MerchantGoods> queryPageNoGoods(@RequestParam(value = "keyword", required = false) String keyword,
                                              @RequestParam(value = "code", required = false) String code,
                                              @RequestParam(value = "noGoodsCodeList", required = false) List<String> noGoodsCodeList,
                                              @RequestParam(value = "brandCode", required = false) String brandCode,
                                              @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
                                              @RequestParam(value = "saleType", required = false) String saleType,
                                              @RequestParam(value = "status", required = false) String status,
                                              @RequestParam(value = "supplierCodeList", required = false) List<String> supplierCodeList,
                                              @RequestParam(value = "queryType", required = false) String queryType,
                                              @RequestParam(value = "limit", defaultValue = "20") int limit,
                                              @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 根据商品编码列表查询对应信息
     *
     * @param codes
     * @return
     */
    @GetMapping("/api/merchant/goods/findMerchantGoodsListByCodes")
    Response<List<MerchantGoods>> findMerchantGoodsListByCodes(@RequestParam(value = "codes") List<String> codes);

    /**
     * 商品列表数据查询(去掉兑换商品中已有的商品信息)
     *
     * @param keyword                 名称 模糊匹配
     * @param code                    编码 模糊匹配
     * @param brandCode               品牌编码 全匹配
     * @param goodsClassificationCode 商品分类编码 全匹配
     * @param status                  商品状态
     * @param limit                   每页条数
     * @param page                    页码
     * @return
     */
    @GetMapping("/api/merchant/goods/queryPageNoRocoMallGoods")
    PageTable<MerchantGoods> queryPageNoRocoMallGoods(@RequestParam(value = "keyword", required = false) String keyword,
                                                      @RequestParam(value = "code", required = false) String code,
                                                      @RequestParam(value = "brandCode", required = false) String brandCode,
                                                      @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
                                                      @RequestParam(value = "saleType", required = false) String saleType,
                                                      @RequestParam(value = "status", required = false) String status,
                                                      @RequestParam(value = "supplierCodeList", required = false) List<String> supplierCodeList,
                                                      @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                      @RequestParam(value = "page", defaultValue = "1") int page);

    /*********************************************   yinshihao MerchantGoods end   ********************************************************************/

    /*********************************************   yinshihao MerchantGoodsLog start   ********************************************************************/

    /**
     * 商品操作日期记录
     *
     * @param goodsCode 商品编码
     * @param limit     每页条数
     * @param page      页码
     * @return
     */
    @GetMapping("/api/merchant/goodsLog/queryPage")
    PageTable<MerchantGoodsLog> merchantGoodsLogPageTable(@RequestParam(value = "goodsCode") String goodsCode,
                                                          @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                          @RequestParam(value = "page", defaultValue = "1") int page);

    /*********************************************   yinshihao MerchantGoodsLog end   ********************************************************************/

    /********************************************* yifenrui 供应商  start******************************************************/

    /**
     * 供应商列表
     *
     * @param code
     * @param name
     * @param status
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/supplier")
    PageTable<MerchantSupplier> searchSupplier(@RequestParam(name = "code", required = false) String code,
                                               @RequestParam(name = "name", required = false) String name,
                                               @RequestParam(name = "status", required = false) String status,
                                               @RequestParam(name = "supplierCodeList", required = false) List<String> supplierCodeList,
                                               @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                               @RequestParam(name = "page", defaultValue = "1") Integer page);

    /**
     * 新增和更新供应商
     *
     * @param merchantSupplier
     * @return
     */
    @PostMapping("/api/merchant/supplier/createOrUpdateMerchantSupplier")
    Response createOrUpdateMerchantSupplier(@RequestBody MerchantSupplier merchantSupplier);

    /**
     * 根据供应商编码获取供应商详情
     *
     * @param code 供应商编码
     * @return
     */
    @GetMapping("/api/merchant/supplier/supplierDetail")
    Response<MerchantSupplier> merchantMerchantSupplierDetailByCode(@RequestParam(value = "code") String code);

    /**
     * 操作供应商状态
     *
     * @param code       供应商编码
     * @param status     目标供应商状态
     * @param updateUser 更新用户
     * @return
     */
    @GetMapping("/api/merchant/supplier/operateStatus")
    Response merchantSupplierStatusOperate(@RequestParam(value = "code") String code, @RequestParam(value = "status") String status, @RequestParam(value = "updateUser") String updateUser, @RequestParam(value = "reason", required = false) String reason);

    /**
     * 供应商操作日志记录
     *
     * @param supplierCode 商户编码
     * @param limit        每页条数
     * @param page         页码
     * @return
     */
    @GetMapping("/api/merchant/supplier/ulog/queryPage")
    PageTable<MerchantSupplierUlog> merchantSupplierUlogPageTable(@RequestParam(value = "supplierCode") String supplierCode,
                                                                  @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                                  @RequestParam(value = "page", defaultValue = "1") int page);
    /********************************************* yifenrui 供应商  end******************************************************/

    /********************************************* yifenrui 商品分类  start******************************************************/
    /**
     * 获取商品分类树.
     *
     * @return
     */
    @GetMapping("/api/merchant/goods/classification/getTree")
    Response<List<TreeDto<MerchantGoodsClassification>>> getMerchantGoodsClassificationTree();

    /**
     * 根据id查询商品分类.
     *
     * @param id the id
     * @return the by id
     */
    @GetMapping("/api/merchant/goods/classification/{id}")
    Response<MerchantGoodsClassification> getMerchantGoodsClassificationById(@PathVariable("id") Integer id);

    /**
     * 根据商品分类编码获取下级列表.
     *
     * @param goodsClassificationCode 服务分类编码
     * @return the response
     */
    @GetMapping("/api/merchant/goods/classification/listByGoodsClassificationCode")
    Response<List<MerchantGoodsClassification>> listByGoodsClassificationCode(@RequestParam("goodsClassificationCode") String goodsClassificationCode);

    @GetMapping("/api/merchant/goods/classification/deleteByGoodsClassCode")
    Response deleteByGoodsClassCode(@RequestParam("goodsClassificationCode") String goodsClassificationCode);

    /**
     * 分页查询商品分类列表
     *
     * @param code
     * @param name
     * @param status
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/goods/classification")
    PageTable<MerchantGoodsClassification> searchMerchantGoodsClassification(@RequestParam(name = "code", required = false) String code,
                                                                             @RequestParam(name = "name", required = false) String name,
                                                                             @RequestParam(name = "status", required = false) String status,
                                                                             @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                                                             @RequestParam(name = "page", defaultValue = "1") Integer page);

    @PostMapping("/api/merchant/goods/classification/saveOrUpdate")
    Response saveOrUpdateMerchantGoodsClassification(@RequestBody MerchantGoodsClassification merchantGoodsClassification);

    /**
     * 前台获取启用状态商品分类树.
     *
     * @return the prefecture tree
     */
    @GetMapping("/api/merchant/goods/classification/getOpenTree")
    Response<List<TreeDto<MerchantGoodsClassification>>> getOpenTree();

    /**
     * 前台根据商品分类编码查询其启用状态的下级列表
     *
     * @param goodsClassificationCode 商品分类编码
     * @return the response
     */
    @GetMapping("/api/merchant/goods/classification/openListByGoodsClassificationCode")
    public Response<List<MerchantGoodsClassification>> openListByGoodsClassificationCode(@RequestParam("goodsClassificationCode") String goodsClassificationCode);

    /********************************************* yifenrui 商品分类  end******************************************************/

    /********************************************* huhailong 商品库存  start******************************************************/
    /**
     * 库存列表
     *
     * @param goodsCode               商品编码
     * @param goodsName               商品名称
     * @param brandCode               品牌编码
     * @param supplierCode            品牌名称
     * @param goodsClassificationCode 分类编码
     * @param orderBy                 排序字段
     * @param direction               生序降序
     * @param limit                   每页多少条
     * @param page                    当前第几页
     * @return
     */
    @GetMapping("/api/merchant/goodsstock/queryPage")
    PageTable<MerchantGoodsStock> merchantGoodsStockPageTable(
            @RequestParam(value = "goodsCode", required = false) String goodsCode,
            @RequestParam(value = "goodsName", required = false) String goodsName,
            @RequestParam(value = "brandCode", required = false) String brandCode,
            @RequestParam(value = "supplierCode", required = false) String supplierCode,
            @RequestParam(value = "supplierCodeList", required = false) List<String> supplierCodeList,
            @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
            @RequestParam(value = "orderBy", required = false, defaultValue = "b.id") String orderBy,
            @RequestParam(value = "sort", required = false, defaultValue = "DESC") Sort.Direction direction,
            @RequestParam(value = "limit", defaultValue = "20") int limit,
            @RequestParam(value = "page", defaultValue = "1") int page);


    /**
     * 库存列表导出
     *
     * @param goodsCode
     * @param goodsName
     * @param brandCode
     * @param supplierCode
     * @param supplierCodeList
     * @param goodsClassificationCode
     * @param orderBy
     * @param direction
     * @return
     */
    @GetMapping("/api/merchant/goodsstock/exportMerchantGoodsStock")
    Response<List<MerchantGoodsStock>> exportMerchantGoodsStock(
            @RequestParam(value = "goodsCode", required = false) String goodsCode,
            @RequestParam(value = "goodsName", required = false) String goodsName,
            @RequestParam(value = "brandCode", required = false) String brandCode,
            @RequestParam(value = "supplierCode", required = false) String supplierCode,
            @RequestParam(value = "supplierCodeList", required = false) List<String> supplierCodeList,
            @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
            @RequestParam(value = "orderBy", required = false, defaultValue = "b.id") String orderBy,
            @RequestParam(value = "sort", required = false, defaultValue = "DESC") Sort.Direction direction);

    /**
     * 获取详细信息，调整库存时使用
     *
     * @param goodsCode
     * @return
     */
    @GetMapping("/api/merchant/goodsstock/getFullInfoByGoodsCode")
    Response<MerchantGoodsStock> getFullInfoByGoodsCode(@RequestParam(value = "goodsCode") String goodsCode);

    /**
     * 适用于后台库存调整 增加，减少，预警调整
     *
     * @param stockAdjustRequest
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/adjustStock")
    Response adjustStock(@RequestBody GoodsStockAdminAdjustRequestDto stockAdjustRequest);

    /**
     * 库存调整日志分页
     *
     * @param goodsCode 商品编码
     * @param limit     每页多少条
     * @param page      当前第几页
     * @return
     */
    @GetMapping("/api/merchant/goodsstocklog/queryPage")
    PageTable<MerchantGoodsStockLog> merchantGoodsStockLogPageTable(
            @RequestParam(value = "goodsCode", required = false) String goodsCode,
            @RequestParam(value = "limit", defaultValue = "20") int limit,
            @RequestParam(value = "page", defaultValue = "1") int page);

    /********************************************* huhailong 商品分类  end******************************************************/

    /********************************************* yinshihao 兑换商品  start******************************************************/

    /**
     * 批量新增兑换商品
     *
     * @param exchangeGoodsList
     * @return
     */
    @PostMapping("/api/merchant/exchangeGoods/batchSaveExchangeGoods")
    Response batchSaveExchangeGoods(@RequestBody List<MerchantExchangeGoods> exchangeGoodsList, @RequestParam("operationUser") String operationUser);

    /**
     * 编辑兑换商品
     *
     * @param exchangeGoods
     * @return
     */
    @PostMapping("/api/merchant/exchangeGoods/editExchangeGoods")
    Response editExchangeGoods(@RequestBody MerchantExchangeGoods exchangeGoods, @RequestParam("map") Map map);

    /**
     * 兑换商品列表数据查询
     *
     * @param name                    名称 模糊匹配
     * @param code                    编码 模糊匹配
     * @param brandCode               品牌编码 全匹配
     * @param supplierCode            供应商编码 全匹配
     * @param goodsClassificationCode 兑换商品分类编码 全匹配
     * @param goodsStatus             商品状态
     * @param exchangeGoodsStatus     兑换商品状态
     * @param limit                   每页条数
     * @param page                    页码
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoods/queryPage")
    PageTable<MerchantExchangeGoods> merchantExchangeGoodsPageTable(@RequestParam(required = false, name = "name") String name,
                                                                    @RequestParam(required = false, name = "code") String code,
                                                                    @RequestParam(required = false, name = "goodsType") String goodsType,
                                                                    @RequestParam(required = false, name = "brandCode") String brandCode,
                                                                    @RequestParam(required = false, name = "supplierCode") String supplierCode,
                                                                    @RequestParam(required = false, name = "goodsClassificationCode") String goodsClassificationCode,
                                                                    @RequestParam(required = false, name = "goodsStatus") String goodsStatus,
                                                                    @RequestParam(required = false, name = "exchangeGoodsStatus") String exchangeGoodsStatus,
                                                                    @RequestParam(value = "supplierCodeList", required = false) List<String> supplierCodeList,
                                                                    @RequestParam(defaultValue = "20", name = "limit") int limit,
                                                                    @RequestParam(defaultValue = "1", name = "page") int page);

    /**
     * 操作兑换商品状态
     *
     * @param code       兑换商品编码
     * @param status     目标兑换商品状态
     * @param updateUser 更新用户
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoods/operateStatus")
    Response merchantExchangeGoodsStatusOperate(@RequestParam("code") String code, @RequestParam("status") String status, @RequestParam("updateUser") String updateUser, @RequestParam("goodsType") String goodsType);

    /**
     * 根据兑换商品编码获取兑换商品详情
     *
     * @param code 兑换商品编码
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoods/goodsDetail")
    Response<MerchantExchangeGoods> merchantExchangeGoodsDetailByCode(@RequestParam("code") String code, @RequestParam("goodsType") String goodsType);

    /**
     * 前端根据兑换商品编码和用户信息获取兑换商品详情
     *
     * @param code 兑换商品编码
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoods/goodsDetailByCodeAndUser")
    Response<MerchantExchangeGoods> goodsDetailByCodeAndUser(@RequestParam("code") String code,
                                                             @RequestParam(value = "identityCode") List<String> identityCode,
                                                             @RequestParam(value = "phone") String phone,
                                                             @RequestParam("goodsType") String goodsType);

    /**
     * 批量操作状态上架下架
     *
     * @param codes       待操作的商户服务项目编码列表
     * @param status      目标状态
     * @param operateUser 操作人
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoods/batch/status")
    Response merchantExchangeGoodsBatchOperateStatus(@RequestParam("codes") String[] codes, @RequestParam("status") String status, @RequestParam("operateUser") String operateUser, @RequestParam("goodsType") String goodsType);

    /**
     * 设置排序值
     *
     * @param code
     * @param seq
     * @param updateUser
     * @return
     */
    @PostMapping("/api/merchant/exchangeGoods/setSeq")
    Response setSeq(@RequestParam("code") String code, @RequestParam("seq") Integer seq, @RequestParam("updateUser") String updateUser, @RequestParam("goodsType") String goodsType);

    /**
     * 查询所有兑换商品列表
     *
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoods/merchantExchangeGoodsList")
    Response<List<MerchantExchangeGoods>> merchantExchangeGoodsList(@RequestParam("goodsType") String goodsType);

    /**
     * 前台查询兑换商品列表
     *
     * @param openAgentPrice
     * @param keyword
     * @param sortType
     * @param goodsClassificationCode
     * @param brandCodeList
     * @param minPrice
     * @param maxPrice
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoods/findExchangeGoodsList")
    PageTable<MerchantExchangeGoods> findExchangeGoodsList(@RequestParam("openAgentPrice") String openAgentPrice,
                                                           @RequestParam(value = "keyword", required = false) String keyword,
                                                           @RequestParam(value = "sortType") String sortType,
                                                           @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
                                                           @RequestParam(value = "brandCodeList", required = false) List<String> brandCodeList,
                                                           @RequestParam(value = "minPrice", required = false) String minPrice,
                                                           @RequestParam(value = "maxPrice", required = false) String maxPrice,
                                                           @RequestParam(value = "identityCode") List<String> identityCode,
                                                           @RequestParam(value = "phone") String phone,
                                                           @RequestParam(value = "goodsType") String goodsType,
                                                           @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                           @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 根据兑换商品状态查询总数
     *
     * @param status 兑换商品状态,若不传则代表查询所有状态的商品
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoods/getTotalExchangeGoods")
    Response<Integer> getTotalExchangeGoods(@RequestParam(required = false, value = "status") String status,@RequestParam(value = "goodsType") String goodsType);

    /**
     * 前端获取随机8件上架的兑换商品
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoods/findRandomLimitEight")
    Response<List<MerchantExchangeGoods>> findRandomLimitEight(@RequestParam(value = "goodsType") String goodsType);

    /**
     * 前端根据兑换商品编码和用户信息获取兑换商品最低价格
     *
     * @param code 兑换商品编码
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoods/getGoodsMinAppointPrice")
    Response<BigDecimal> getGoodsMinAppointPrice(@RequestParam("code") String code,
                                                        @RequestParam(value = "identityCode") List<String> identityCode,
                                                        @RequestParam(value = "phone") String phone,
                                                        @RequestParam(value = "goodsType") String goodsType);

    /**
     *
     * 首页根据排序值获取10个兑换商品
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoods/getTenExchangeGoodsBySort")
    Response<List<MerchantExchangeGoods>> getTenExchangeGoodsBySort();
    /********************************************* yinshihao 兑换商品  end******************************************************/

    /********************************************* yinshihao 兑换商品操作日志  start******************************************************/

    /**
     * 兑换商品操作日期记录
     *
     * @param goodsCode 商品编码
     * @param limit     每页条数
     * @param page      页码
     * @return
     */

    @GetMapping("/api/merchant/exchangeGoodsLog/queryPage")
    PageTable<MerchantExchangeGoodsLog> merchantExchangeGoodsLogPageTable(@RequestParam("goodsCode") String goodsCode,
                                                                          @RequestParam("goodsType") String goodsType,
                                                                          @RequestParam(defaultValue = "20", name = "limit") int limit,
                                                                          @RequestParam(defaultValue = "1", name = "page") int page);

    /********************************************* yinshihao 兑换商品操作日志  end******************************************************/

    /********************************************* yinshihao 兑换商品特价  start******************************************************/

    /**
     * 导入
     *
     * @param merchantExchangeGoodsSpecialPriceList
     * @param updateUser
     * @return
     */
    @PostMapping("/api/merchant/exchangeGoodsSpecialPrice/importAppointPrice")
    Response importAppointPrice(@RequestBody List<MerchantExchangeGoodsSpecialPrice> merchantExchangeGoodsSpecialPriceList, @RequestParam("updateUser") String updateUser, @RequestParam("goodsType") String goodsType);

    /**
     * 根据手机号查询该用户是否是代理人
     *
     * @param phone
     * @return
     */
    @GetMapping("/api/merchant/exchangeGoodsSpecialPrice/getUserIsAgent")
    Response getUserIsAgent(@RequestParam(value = "phone") String phone, @RequestParam(value = "goodsType") String goodsType);

    /********************************************* yinshihao 兑换商品特价  end******************************************************/

    /********************************************* huhl 数据权限管理  start******************************************************/
    @GetMapping("/api/merchant/supplier/supplierList")
    Response<List<MerchantSupplier>> merchantSupplierList();

    /********************************************* huhl 数据权限管理  end******************************************************/

    /******************************************************huhl 订单库存操作 start******************************************************************/
    /**
     * 订单库存占用，非购物车形式订单；一个订单就一个商品
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderStockOccupied")
    Response orderStockOccupied(@RequestBody OrderStockRequestDTO orderStockRequestDTO);

    /**
     * 订单库存扣减，非购物车形式订单；
     * 使用订单号维度, 获取库存占用记录,根据占用数进行库存：占用减少，销售增加。
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderStockReduce")
    Response orderStockOut(@RequestBody OrderStockRequestDTO orderStockRequestDTO);

    /**
     * 订单库存还原，非购物车形式订单；
     * 使用订单号维度, 获取库存占用记录,根据占用记录决定还原占用库存/已出库库存，影响库存。
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderStockCancel")
    Response orderStockCancel(@RequestBody OrderStockRequestDTO orderStockRequestDTO);

    /**
     * 订单虚拟商品出库占用卡密，非购物车形式订单。
     * 使用订单号维度，占用卡券后没有还原操作
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderVCardSend")
    Response orderVCardSend(@RequestBody OrderStockRequestDTO orderStockRequestDTO);

    /**
     * 根据订单号获取卡密，只传递订单号就行
     *
     * @param orderNo
     * @return
     */
    @GetMapping("/api/merchant/goodsstock/getVCardByOrderNo")
    Response<List<OrderVCardResponseItem>> getVCardByOrderNo(@RequestParam("orderNo") String orderNo);

    /**
     * 展示
     *
     * @param query
     * @return
     */
    @PostMapping("/api/merchant/goodsvcardstock/queryPage")
    PageTable<MerchantGoodsVCardStock> merchantGoodsVCardStockPageTable(@RequestBody GoodsVcardStockPageRequestDto query);

    /**
     * 导入
     *
     * @param vCardStocks
     * @return
     */
    @PostMapping("/api/merchant/goodsvcardstock/importBatchVCard")
    Response<Integer> importBatchVCard(@RequestBody List<MerchantGoodsVCardStock> vCardStocks);

    /**
     * huhl 添加，得到用户供应商权限中的所有虚拟商品编码，为了导入虚拟卡时进行校验
     *
     * @return
     */
    @PostMapping("/api/merchant/goods/getSupplierInventedGoodsCodeList")
    Response<List<String>> getSupplierInventedGoodsCodeList(@RequestBody List<String> supplierCodeList);

    /**
     * @param requestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsvcardstock/setVCardToVoid")
    Response setVCardToVoid(@RequestBody VCardToVoidRequestDTO requestDTO);

    /**
     * 更新无效库存任务
     *
     * @return
     */
    @GetMapping("/api/merchant/goodsvcardstock/updateVCardExpireTask")
    Response updateVCardExpireTask();

    /*******************************************************huhl 订单库存操作 end**************************************************/

    /*******************************************************yifenrui 商户投保礼 start**************************************************/

    /**
     * 后台投保礼-商品列表
     *
     * @param code
     * @param giftType
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/insurancegift/goodsList")
    PageTable<MerchantInsuranceGift> getMerchantInsuranceGiftByStoreCodeAndTypePageTable(@RequestParam(name = "code") String code, @RequestParam(name = "giftType") String giftType,
                                                                                         @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                                                         @RequestParam(value = "page", defaultValue = "1") int page);

    @GetMapping("/api/merchant/insurancegift/getCombPackagePageTable")
    PageTable<MerchantInsuranceGift> getCombPackagePageTable(@RequestParam(name = "code") String code, @RequestParam(name = "giftType") String giftType,
                                                             @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                             @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 后台投保礼-更改状态和排序
     *
     * @param merchantInsuranceGift
     * @return
     */
    @PostMapping("/api/merchant/insurancegift/statusOrSort")
    Response switchMerchantInsuranceGiftStatusOrSort(@RequestBody MerchantInsuranceGift merchantInsuranceGift);


    /**
     * 组合套餐修改
     * @param merchantInsuranceGift
     * @return
     */
    @PostMapping("/api/merchant/insurancegift/switchComPackageStatusOrSort")
    Response switchComPackageStatusOrSort(@RequestBody MerchantInsuranceGift merchantInsuranceGift);


    /**
     * 后台投保礼-通过id删除
     *
     * @param merchantInsuranceGift
     * @return
     */
    @PostMapping("/api/merchant/insurancegift/removeById")
    Response removeById(@RequestBody MerchantInsuranceGift merchantInsuranceGift);

    /**
     * 后台投保礼-获取商户关联的投保礼code
     *
     * @param merchantInsuranceGift
     * @return
     */
    @PostMapping("/api/merchant/insurancegift/getGoodCodes")
    Response getGoodCodes(@RequestBody MerchantInsuranceGift merchantInsuranceGift);

    @PostMapping("/api/merchant/insurancegift/getCombCodes")
    Response getCombCodes(@RequestBody MerchantInsuranceGiftCombRelate merchantInsuranceGiftCombRelate);

    /**
     * 后台新增投保礼
     *
     * @param merchantInsuranceGift
     * @return
     */
    @PostMapping("/api/merchant/insurancegift/createGift")
    Response createGift(@RequestBody List<MerchantInsuranceGift> merchantInsuranceGift);


    @PostMapping("/api/merchant/account/createPermission")
    Response createPermission(@RequestBody List<MerchantStoreAccountPermission> merchantStoreAccountPermission);


    @PostMapping("/api/merchant/insurancegift/createPackageGift")
    Response createPackageGift(@RequestBody List<MerchantInsuranceGiftCombRelate> merchantInsuranceGiftCombRelate);

    /**
     * 商户聚合端接口-选择投保礼
     *
     * @param storeCode
     * @param keyword
     * @param giftType
     * @param minMarketPrice
     * @param maxMarketPrice
     * @param minCostPrice
     * @param maxCostPrice
     * @param marketPriceASC
     * @param marketPriceDESC
     * @param costPriceASC
     * @param costPriceDESC
     * @return
     */
    @GetMapping("/api/merchant/insurancegift/queryGiftList")
    Response<List<MerchantInsuranceGift>> queryGiftList(@RequestParam(value = "storeCode",required = false) String storeCode, @RequestParam(value = "keyword", required = false) String keyword, @RequestParam(value = "giftType") String giftType,
                                                        @RequestParam(value = "remainPrice") BigDecimal remainPrice, @RequestParam(value = "minMarketPrice", required = false) String minMarketPrice, @RequestParam(value = "maxMarketPrice", required = false) String maxMarketPrice,
                                                        @RequestParam(value = "minCostPrice", required = false) String minCostPrice, @RequestParam(value = "maxCostPrice", required = false) String maxCostPrice, @RequestParam(value = "marketPriceASC", required = false) String marketPriceASC,
                                                        @RequestParam(value = "marketPriceDESC", required = false) String marketPriceDESC, @RequestParam(value = "costPriceASC", required = false) String costPriceASC,
                                                        @RequestParam(value = "costPriceDESC", required = false) String costPriceDESC);
    /**
     * 选择投保礼
     * @return
     */
    @PostMapping("/api/merchant/insurancegift/queryGiftPage")
    PageTable<MerchantInsuranceGift> queryGiftPage(@RequestBody ReqParamGift req);

    /**
     * 商户聚合端接口-推荐商品
     * @param storeCode
     * @param remainPrice
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/insurancegift/queryRecommendGiftList")
    PageTable<MerchantInsuranceGift> queryRecommendGiftList(@RequestParam(value = "storeCode",required = false) String storeCode, @RequestParam(value = "remainPrice")  BigDecimal remainPrice,
                                                            @RequestParam(value = "costCoefficent") String costCoefficent,  @RequestParam(value = "inflationCoefficent")  String inflationCoefficent,
                                                            @RequestParam(value = "remainFloatCoefficent")  String remainFloatCoefficent,@RequestParam(value = "remainPriceCoefficent")  String remainPriceCoefficent,
                                                            @RequestParam(value = "limit", defaultValue = "20") int limit,@RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 根据商户编号，礼品编号list获取礼品列表
     *
     * @param codes
     * @param storeCode
     * @return
     */
    @GetMapping("/api/merchant/insurancegift/findMerchantGiftListByCodes")
    Response<List<MerchantInsuranceGift>> findMerchantGiftListByCodes(@RequestParam(value = "codes") List<String> codes, @RequestParam(value = "storeCode",required = false) String storeCode);


    /**
     * 根据商品code+商户code查询投保礼价格
     * @param goodsCode
     * @param storeCode
     * @return
     */
    @GetMapping("/api/merchant/insurancegift/getMerchantGiftDetailByGoodsCodeAndStoreCode")
    Response<MerchantInsuranceGift> getMerchantGiftDetailByGoodsCodeAndStoreCode(@RequestParam(value = "goodsCode") String goodsCode, @RequestParam(value = "storeCode",required = false) String storeCode);

    /**
     * 组合套餐-项目列表
     *
     * @param code
     * @return
     */
    @GetMapping("/api/merchant/insurancegift/getCombRelatePackageGiftByStoreCodeAndTypePageTable")
    Response<List<MerchantInsuranceGiftCombRelate>> getCombRelatePackageGiftByStoreCodeAndTypePageTable(@RequestParam(name = "code") String code);


    /**
     * 设置全部投保礼列表
     * @param code
     * @param code
     * @param name
     * @param type
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/totalgift/merchantMerchantInsuranceTotalGiftPageTable")
    PageTable<MerchantInsuranceTotalGift> merchantMerchantInsuranceTotalGiftPageTable(
                                                                                      @RequestParam(value = "code", required = false) String code,
                                                                                      @RequestParam(value = "name", required = false) String name,
                                                                                      @RequestParam(value = "type",required = false) String type,
                                                                                      @RequestParam(value = "typeStatus",required = false) String typeStatus,
                                                                                      @RequestParam(value = "status",required = false) String status,
                                                                                      @RequestParam(value = "sourceType",required = false) String sourceType,
                                                                                      @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                                                      @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 礼品类型查询code列表
     * @param merchantInsuranceTotalGift
     * @return
     */
    @PostMapping("/api/merchant/totalgift/getTotalGiftGoodCodes")
    Response getTotalGiftGoodCodes(@RequestBody MerchantInsuranceTotalGift merchantInsuranceTotalGift);

    /**
     * 后台新增全部投保礼
     *
     * @param merchantInsuranceTotalGift
     * @return
     */
    @PostMapping("/api/merchant/totalgift/createTotalGift")
    Response createTotalGift(@RequestBody List<MerchantInsuranceTotalGift> merchantInsuranceTotalGift);


    /**
     * 后台全部投保礼-更改状态和排序
     *
     * @param merchantInsuranceTotalGift
     * @return
     */
    @PostMapping("/api/merchant/totalgift/statusOrSort")
    Response switchMerchantInsuranceTotalGiftStatusOrSort(@RequestBody MerchantInsuranceTotalGift merchantInsuranceTotalGift);


    /**
     * 根据礼品编码获取指定角色列表
     *
     * @param giftCode 礼品编码
     * @return
     */
    @GetMapping("/api/merchant/totalgift/giftRoleList")
    Response<List<MerchantInsuranceTotalGiftRoleRelate>> giftRoleList(@RequestParam("giftCode") String giftCode);


    /**
     * 获取通用投保礼列表
     * @param status
     * @param code
     * @param excludedCode
     * @return
     */
    @GetMapping("/api/merchant/totalgift/searchOilCashCouponForTotalGift")
    Response<List<MerchantInsuranceTotalGift>> searchOilCashCouponForTotalGift(@RequestParam(value = "status", defaultValue = "UP_LIST") String status,
                                                    @RequestParam(value = "code", required = false) String code,
                                                    @RequestParam(value = "excludedCode", required = false) String[] excludedCode);

    /**
     * 后台全部投保礼-编辑投保礼
     * @param merchantInsuranceTotalGift
     * @param map
     * @return
     */
    @PostMapping("/api/merchant/totalgift/editMerchantInsuranceTotalGift")
    Response editMerchantInsuranceTotalGift(@RequestBody MerchantInsuranceTotalGift merchantInsuranceTotalGift, @RequestParam("map") Map map);

    /**
     *
     * 后台全部投保礼-全部投保礼日志
     * @param giftCode
     * @param limit
     * @param page
     * @return
     */

    @GetMapping("/api/merchant/totalgift/merchantTotalGiftLogPageTable")
    PageTable<MerchantInsuranceTotalGiftLog> merchantTotalGiftLogPageTable(@RequestParam("giftCode") String giftCode,
                                                                           @RequestParam(defaultValue = "20", name = "limit") int limit,
                                                                           @RequestParam(defaultValue = "1", name = "page") int page);


    /**
     * 后台全部投保礼-批量
     * @param codes
     * @param status
     * @param operateUser
     * @return
     */
    @GetMapping("/api/merchant/totalgift/merchantTotalGiftBatchOperateStatus")
    Response merchantTotalGiftBatchOperateStatus(@RequestParam("codes") String[] codes, @RequestParam("status") String status, @RequestParam("operateUser") String operateUser);

    /**
     * 通用投保礼更改排序检测重复
     * @param type
     * @param sort
     * @return
     */
    @GetMapping("/api/merchant/totalgift/updateTotalGiftSortCheck")
    Response<List<MerchantInsuranceTotalGift>> updateTotalGiftSortCheck(@RequestParam(value = "id", required = false) Integer id,
                                                                        @RequestParam(value = "type", required = false) String type,
                                                                        @RequestParam(value = "sort", required = false) Integer sort,
                                                                        @RequestParam(value = "sourceType", required = false) String sourceType);



    /**
     * 商户投保礼更改排序检测重复-组合套餐，项目
     * @param relateType
     * @param sort
     * @return
     */
    @GetMapping("/api/merchant/insurancegift/updateGiftSortCheck")
    Response<List<MerchantInsuranceGift>> updateGiftSortCheck(@RequestParam(value = "id", required = false) Integer id,
                                                              @RequestParam(value = "storeCode", required = false) String storeCode,
                                                              @RequestParam(value = "relateType", required = false) String relateType,@RequestParam(value = "sort", required = false) Integer sort);

    /**
     * 首页板块推荐--  根据投保礼商品编码列表查询对应信息  尹世豪加
     * @param codes
     * @return
     */
    @GetMapping("/api/merchant/totalgift/findTotalGiftListByCodes")
    Response<List<MerchantInsuranceTotalGift>> findTotalGiftListByCodes(@RequestParam(value = "codes") List<String> codes, @RequestParam(value = "status", required = false) String status);


    /**
     * 通用投保礼弹窗
     * @param keyword
     * @param code
     * @param noGiftsCodeList
     * @param status
     * @param queryType
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/totalgift/queryPageNoTotalGift")
    PageTable<MerchantInsuranceTotalGift> queryPageNoTotalGift(@RequestParam(value = "keyword", required = false) String keyword,
                                              @RequestParam(value = "code", required = false) String code,
                                              @RequestParam(value = "noGiftsCodeList", required = false) List<String> noGiftsCodeList,
                                              @RequestParam(value = "status", required = false) String status,
                                              @RequestParam(value = "sourceType", required = false) String sourceType,
                                              @RequestParam(value = "queryType", required = false) String queryType,
                                              @RequestParam(value = "limit", defaultValue = "20") int limit,
                                              @RequestParam(value = "page", defaultValue = "1") int page);
    /*******************************************************yifenrui 商户投保礼 end**************************************************/

    /*********************************************************huhailong 购物车形式订单库存操作***************************************/

    /**
     * 订单库存占用，类似购物车形式。因先按是单商品购物写的库存管理，后面需求调整有需要类似购物车形式的，单商品库存管理保留。
     * 一次占用多个商品库存，参数goods是必填
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderBatchStockOccupied")
    Response orderBatchStockOccupied(@RequestBody @Validated OrderBatchStockRequestDto orderStockRequestDTO);

    /**
     * 订单库存发货扣减，类似购物车形式。因先按是单商品购物写的库存管理，后面需求调整有需要类似购物车形式的，单商品库存管理保留。
     * 使用订单号维度 整体进行商品的库存扣减。并不使用goods参数。
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderBatchStockReduce")
    Response orderBatchStockReduce(@RequestBody @Validated OrderBatchStockRequestDto orderStockRequestDTO);

    /**
     * 订单库存还原，类似购物车形式。因先按是单商品购物写的库存管理，后面需求调整有需要类似购物车形式的，单商品库存管理保留。
     * 实现里面 使用到了 cancelGoodList，看着是支持部分商品取消，但后来咨询同同，说后面又不需要部分取消了。
     * 如果不需要部分取消只传递订单号，如果需要部分取消传递cancelGoodList
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderBatchStockCancel")
    Response orderBatchStockCancel(@RequestBody @Validated OrderBatchStockRequestDto orderStockRequestDTO);

    /**
     * 订单虚拟卡密发货，类似购物车形式。因先按是单商品购物写的库存管理，后面需求调整有需要类似购物车形式的，单商品库存管理保留。
     * 使用订单号维度，获取此订单占用记录的所有商品，过滤出没有取消库存的虚拟商品，占用库存。要成功都成功，卡密库存不足则不能发货
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderBatchVCardSend")
    Response orderBatchVCardSend(@RequestBody @Validated OrderBatchStockRequestDto orderStockRequestDTO);

    /*********************************************************huhailong 购物车形式订单库存操作 end***************************************/

    // =========  start of  商户身份   ===========

    /**
     * Save or update merchant identity response.
     *
     * @param merchantIdentity the merchant identity
     * @return the response
     */
    @PostMapping("/api/merchant/merchant-identity")
    Response saveOrUpdateMerchantIdentity(@RequestBody MerchantStoreAccountIdentity merchantIdentity);

    /**
     * List merchant identity response.
     *
     * @param storeAccountCode the storeAccountCode
     * @return the response
     */
    @GetMapping("/api/merchant/merchant-identity/list")
    Response<List<MerchantStoreAccountIdentity>> listMerchantStoreIdentity(@RequestParam(value = "storeAccountCode", required = false) String storeAccountCode,
                                                                           @RequestParam(value = "identityTypeCode", required = false) String identityTypeCode);
    // =========  end of  商户身份   ===========


    /*********************************************************huhailong 购物车形式订单库存操作 begin***************************************/

    /**
     * 业务端 订单库存重复占用，场景订单占用库存，取消后，重新占用库存.
     * 原订单需要都取消库存后，再调用这个接口
     * 会删除流水记录，重新占用库存
     * @param orderStockRequestDTO 多个商品的库存占用
     * @return
     */
     @PostMapping("/api/merchant/goodsstock/orderBatchStockRepeatOccupied")
     Response orderBatchStockRepeatOccupied(@RequestBody OrderBatchStockRequestDto orderStockRequestDTO);

    /**
     * 通过商户编码查询可用库存
     * @param codes 商品编码列表
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/merchantGoodsSellableStock")
    Response<List<MerchantGoodsStock>> merchantGoodsSellableStock(@RequestBody List<String> codes);

    /**
     * 查询商品列表，含库存
     * @param paramGoods
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/queryListWithStock")
    Response<List<MerchantGoodsStock>> queryListWithStock(@RequestBody ReqParamGoods paramGoods);
    /*********************************************************huhailong 购物车形式订单库存操作 end***************************************/

    /********************************************* yinshihao ROCO商城商品  start******************************************************/

    /**
     * 批量新增ROCO商城商品
     *
     * @param rocoMallGoodsList
     * @return
     */
    @PostMapping("/api/merchant/rocoMallGoods/batchSaveRocoMallGoods")
    Response batchSaveRocoMallGoods(@RequestBody List<MerchantRocoMallGoods> rocoMallGoodsList, @RequestParam("operationUser") String operationUser);

    /**
     * 编辑ROCO商城商品
     *
     * @param rocoMallGoods
     * @return
     */
    @PostMapping("/api/merchant/rocoMallGoods/editRocoMallGoods")
    Response editRocoMallGoods(@RequestBody MerchantRocoMallGoods rocoMallGoods, @RequestParam("map") Map map);

    /**
     * ROCO商城商品列表数据查询
     *
     * @param name                    名称 模糊匹配
     * @param code                    编码 模糊匹配
     * @param brandCode               品牌编码 全匹配
     * @param supplierCode            供应商编码 全匹配
     * @param goodsClassificationCode ROCO商城商品分类编码 全匹配
     * @param goodsStatus             商品状态
     * @param rocoMallGoodsStatus     ROCO商城商品状态
     * @param limit                   每页条数
     * @param page                    页码
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/queryPage")
    PageTable<MerchantRocoMallGoods> merchantRocoMallGoodsPageTable(@RequestParam(required = false, name = "name") String name,
                                                                    @RequestParam(required = false, name = "code") String code,
                                                                    @RequestParam(required = false, name = "brandCode") String brandCode,
                                                                    @RequestParam(required = false, name = "supplierCode") String supplierCode,
                                                                    @RequestParam(required = false, name = "goodsClassificationCode") String goodsClassificationCode,
                                                                    @RequestParam(required = false, name = "goodsStatus") String goodsStatus,
                                                                    @RequestParam(required = false, name = "rocoMallGoodsStatus") String rocoMallGoodsStatus,
                                                                    @RequestParam(value = "supplierCodeList", required = false) List<String> supplierCodeList,
                                                                    @RequestParam(defaultValue = "20", name = "limit") int limit,
                                                                    @RequestParam(defaultValue = "1", name = "page") int page);

    /**
     * 操作ROCO商城商品状态
     *
     * @param code       ROCO商城商品编码
     * @param status     目标ROCO商城商品状态
     * @param updateUser 更新用户
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/operateStatus")
    Response merchantRocoMallGoodsStatusOperate(@RequestParam("code") String code, @RequestParam("status") String status, @RequestParam("updateUser") String updateUser);

    /**
     * 根据ROCO商城商品编码获取ROCO商城商品详情
     *
     * @param code ROCO商城商品编码
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/goodsDetail")
    Response<MerchantRocoMallGoods> merchantRocoMallGoodsDetailByCode(@RequestParam("code") String code);

    /**
     * 前端根据ROCO商城商品编码和用户信息获取ROCO商城商品详情
     *
     * @param code ROCO商城商品编码
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/goodsDetailByCodeAndUser")
    Response<MerchantRocoMallGoods> goodsDetailByCodeAndUser(@RequestParam("code") String code,
                                                             @RequestParam(value = "identityCode") List<String> identityCode,
                                                             @RequestParam(value = "phone") String phone);

    /**
     * 批量操作状态上架下架
     *
     * @param codes       待操作的商户服务项目编码列表
     * @param status      目标状态
     * @param operateUser 操作人
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/batch/status")
    Response merchantRocoMallGoodsBatchOperateStatus(@RequestParam("codes") String[] codes, @RequestParam("status") String status, @RequestParam("operateUser") String operateUser);

    /**
     * 设置排序值
     *
     * @param code
     * @param seq
     * @param updateUser
     * @return
     */
    @PostMapping("/api/merchant/rocoMallGoods/setSeq")
    Response setSeq(@RequestParam("code") String code, @RequestParam("seq") Integer seq, @RequestParam("updateUser") String updateUser);

    /**
     * 查询所有ROCO商城商品列表
     *
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/merchantRocoMallGoodsList")
    Response<List<MerchantRocoMallGoods>> merchantRocoMallGoodsList();

    /**
     * 前台查询ROCO商城商品列表
     *
     * @param openAgentPrice
     * @param keyword
     * @param sortType
     * @param goodsClassificationCode
     * @param brandCodeList
     * @param minPrice
     * @param maxPrice
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/findRocoMallGoodsList")
    PageTable<MerchantRocoMallGoods> findRocoMallGoodsList(@RequestParam("openAgentPrice") String openAgentPrice,
                                                           @RequestParam(value = "keyword", required = false) String keyword,
                                                           @RequestParam(value = "sortType") String sortType,
                                                           @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
                                                           @RequestParam(value = "brandCodeList", required = false) List<String> brandCodeList,
                                                           @RequestParam(value = "minPrice", required = false) String minPrice,
                                                           @RequestParam(value = "maxPrice", required = false) String maxPrice,
                                                           @RequestParam(value = "identityCode") List<String> identityCode,
                                                           @RequestParam(value = "phone") String phone,
                                                           @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                           @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 根据ROCO商城商品状态查询总数
     *
     * @param status ROCO商城商品状态,若不传则代表查询所有状态的商品
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/getTotalRocoMallGoods")
    Response<Integer> getTotalRocoMallGoods(@RequestParam(required = false, value = "status") String status);

    /**
     * 前端获取随机8件上架的ROCO商城商品
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/findRandomLimitEight")
    Response<List<MerchantRocoMallGoods>> findRandomLimitEight();

    /**
     * 前端根据ROCO商城商品编码和用户信息获取ROCO商城商品最低价格
     *
     * @param code ROCO商城商品编码
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/getGoodsMinAppointPrice")
    Response<BigDecimal> getGoodsMinAppointPrice(@RequestParam("code") String code,
                                                 @RequestParam(value = "identityCode") List<String> identityCode,
                                                 @RequestParam(value = "phone") String phone);

    /**
     * 前台匿名查询ROCO商城商品列表
     *
     * @param keyword
     * @param sortType
     * @param goodsClassificationCode
     * @param brandCodeList
     * @param minPrice
     * @param maxPrice
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoods/noAccessFindRocoMallGoodsList")
    PageTable<MerchantRocoMallGoods> noAccessFindRocoMallGoodsList(@RequestParam(value = "keyword", required = false) String keyword,
                                                           @RequestParam(value = "sortType") String sortType,
                                                           @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
                                                           @RequestParam(value = "brandCodeList", required = false) List<String> brandCodeList,
                                                           @RequestParam(value = "minPrice", required = false) String minPrice,
                                                           @RequestParam(value = "maxPrice", required = false) String maxPrice,
                                                           @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                           @RequestParam(value = "page", defaultValue = "1") int page);

    /********************************************* yinshihao ROCO商城商品  end******************************************************/

    /********************************************* yinshihao ROCO商城商品操作日志  start******************************************************/

    /**
     * ROCO商城商品操作日期记录
     *
     * @param goodsCode 商品编码
     * @param limit     每页条数
     * @param page      页码
     * @return
     */

    @GetMapping("/api/merchant/rocoMallGoodsLog/queryPage")
    PageTable<MerchantRocoMallGoodsLog> merchantRocoMallGoodsLogPageTable(@RequestParam("goodsCode") String goodsCode,
                                                                          @RequestParam(defaultValue = "20", name = "limit") int limit,
                                                                          @RequestParam(defaultValue = "1", name = "page") int page);

    /********************************************* yinshihao ROCO商城商品操作日志  end******************************************************/

    /********************************************* yinshihao ROCO商城商品特价  start******************************************************/

    /**
     * 导入
     *
     * @param merchantRocoMallGoodsSpecialPriceList
     * @param updateUser
     * @return
     */
    @PostMapping("/api/merchant/rocoMallGoodsSpecialPrice/importAppointPrice")
    Response importAppointPrice(@RequestBody List<MerchantRocoMallGoodsSpecialPrice> merchantRocoMallGoodsSpecialPriceList, @RequestParam("updateUser") String updateUser);

    /**
     * 根据手机号查询该用户是否是代理人
     *
     * @param phone
     * @return
     */
    @GetMapping("/api/merchant/rocoMallGoodsSpecialPrice/getUserIsAgent")
    Response getUserIsAgent(@RequestParam(value = "phone") String phone);

    /********************************************* yinshihao ROCO商城商品特价  end******************************************************/



    /********************************************* yifenrui 代理人一键购买  start******************************************************/

    /**
     * 一键购买商品
     * @param keyword
     * @param goodsClassificationCode
     * @param minSettlePrice
     * @param maxSettlePrice
     * @param minMarketPrice
     * @param maxMarketPrice
     * @param settlePriceASC
     * @param settlePriceDESC
     * @param marketPriceASC
     * @param marketPriceDESC
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/insurancegift/queryOneClickGoodsList")
    PageTable<MerchantInsuranceGift> queryOneClickGoodsList(@RequestParam(value = "keyword",required = false) String keyword,
                                                            @RequestParam(value = "goodsClassificationCode", required = false) String goodsClassificationCode,
                                                            @RequestParam(value = "minSettlePrice", required = false) String minSettlePrice,
                                                            @RequestParam(value = "maxSettlePrice", required = false) String maxSettlePrice,
                                                            @RequestParam(value = "minMarketPrice", required = false) String minMarketPrice,
                                                            @RequestParam(value = "maxMarketPrice", required = false) String maxMarketPrice,
                                                            @RequestParam(value = "settlePriceASC", required = false) String settlePriceASC,
                                                            @RequestParam(value = "settlePriceDESC", required = false) String settlePriceDESC,
                                                            @RequestParam(value = "marketPriceASC", required = false) String marketPriceASC,
                                                            @RequestParam(value = "marketPriceDESC", required = false) String marketPriceDESC,
                                                            @RequestParam(value = "discountASC", required = false) String discountASC,
                                                            @RequestParam(value = "discountDESC", required = false) String discountDESC,
                                                            @RequestParam(value = "limit", defaultValue = "20") int limit,@RequestParam(value = "page", defaultValue = "1") int page);


    /**
     * 车主端-获取商品1级分类
     * @return
     */
    @GetMapping("/api/merchant/goods/classification/getFirstGoodsClassification")
     Response<List<MerchantGoodsClassification>> getFirstGoodsClassification();


    /**
     * 车主端-查看一键购买商品详情
     * @param code
     * @return
     */
    @GetMapping("/api/merchant/totalgift/merchantInsuranceTotalGiftDetailByCode")
    Response<MerchantInsuranceTotalGift> merchantInsuranceTotalGiftDetailByCode(@RequestParam(value = "code") String code);
    /********************************************* yifenrui 代理人一键购买  end******************************************************/




}

