package com.rocogz.merchant.entity.label;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * 商户标签
 * </p>
 *
 * @author yinshihao
 * @since 2020-03-30
 */
@TableName(value = "merchant_label")
@JsonIgnoreProperties(ignoreUnknown = true)
@Data
public class MerchantLabel extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 标签编号
     */
    private String code;

    /**
     * 标签名称
     */
    private String name;

    /**
     * 所属专区编码
     */
    @TableField(exist = false)
    private List<String> prefectureCode;

    /**
     * 标签说明
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String description;

    /**
     * 状态
     */
    private String status;

}
