package com.rocogz.merchant.entity.store;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 商户营业信息
 * </p>
 *
 * @author liangyongtong
 * @since 2020-04-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantStoreBusiness extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 商户编码
     */
    private String storeCode;

    /**
     * 法人代表
     */
    private String lealPerson;

    /**
     * 详细地址
     */
    private String detailAddress;

    /**
     * 营业执照号
     */
    private String businessLicenseNo;

    /**
     * 营业执照图片
     */
    private String businessLicenseImg;

    /**
     * 营业开始时间
     */
    private String businessStartTime;

    /**
     * 营业结束时间
     */
    private String businessEndTime;

}
