package com.rocogz.merchant.entity.store;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <p>
 * 商户评分订单统计
 * </p>
 *
 * @author liangyongtong
 * @since 2020-05-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantStoreKpi extends IdEntity {

    private static final long serialVersionUID = 5659515255281838644L;
    /**
     * 商户编码
     */
    private String storeCode;

    /**
     * 专区编码
     */
    private String areaCode;

    /**
     * 商户评价平均分
     */
    private BigDecimal score;

    /**
     * 商户订单数
     */
    private Integer orders;
}
