package com.rocogz.merchant.request.customer.goods;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.Digits;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 合作客户产品保存请求类
 * </p>
 *
 * @author djt
 * @since 2020-12-16
 */
@Data
public class MerchantCustomerGoodsSaveReq implements Serializable {

    /**
     * 合作客户产品编号
     */
    private String code;

    /**
     * 合作客户产品名称
     */
    @NotBlank
    private String name;

    /**
     * 代理商产品编号
     */
    @NotBlank(message = "代理商产品编号不能为空")
    private String agentGoodsCode;

    /**
     * 合作商户编号
     */
    @NotBlank(message = "合作商户编号不能为空")
    private String customerCode;

    /**
     * 代理商编号(merchant_agent.code)
     */
    @NotBlank(message = "代理商编号不能为空")
    private String agentCode;

    /**
     * 客户专享价
     */
    @NotNull
    @Digits(integer=10,fraction = 2)
    @NotNull(message = "客户专享价不能为空")
    private BigDecimal settlePrice;

    /**
     * 市场价
     */
    @Digits(integer=10,fraction = 2)
    @NotNull(message = "市场价不能为空")
    private BigDecimal marketPrice;

    /**
     * 渠道价
     */
    @Digits(integer=10,fraction = 2)
    private BigDecimal channelPrice;

    /**
     * 产品说明
     */
    @Length(max = 300,message = "代理商产品说明不得超过300个字符")
    private String introduce;

    /**
     * 上下架状态
     */
    @NotBlank(message = "上下架状态不能为空")
    private String status;


    /**
     * 创建人id
     */
    @NotNull
    private Integer createUser;

    /**
     * 创建人名称
     */
    @NotBlank
    private String createUserName;



    /**
     * 更新人id
     */
    @NotNull
    private Integer updateUser;

    /**
     * 更新人名称
     */
    @NotBlank
    private String updateUserName;


}
