package com.rocogz.merchant.entity.product;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 商户中心-产品类型表
 * </p>
 *
 * @author ranxiangfu
 * @since 2021-01-27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("merchant_product_type")
public class MerchantProductType extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 父级产品类型编码,父级产品类型编码为0的为一级产品类型
     */
    private String parentCode;

    /**
     * 产品类型编码
     */
    private String code;

    /**
     * 产品类型名称
     */
    private String name;

    /**
     * 状态
     */
    private String status;

    /**
     * 排序号
     */
    private Integer sortNum;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新人
     */
    private String updateUser;


}
