package com.rocogz.merchant.entity.store;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 商户账号登录过的微信号
 * </p>
 *
 * @author liangyongtong
 * @since 2020-04-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantStoreAccountLoginStatus extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 商户账号
     */
    private String accountCode;

    /**
     * 微信号
     */
    private String wxNo;

    /**
     * 微信号
     */
    private String wxOpenid;

    /**
     * 微信昵称
     */
    private String wxNickname;

    /**
     * 关联时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime relateTime;

    /**
     * 微信头像路径
     */
    private String wxImage;

    /**
     * 当前该账号的状态
     */
    @TableField(exist = false)
    private String status;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime updateTime;
}
