/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.merchant.dto.scm.order;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.merchant.dto.scm.order.SettleReceiptItem;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.springframework.util.CollectionUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class ScmOrderSettleBaseDto<ITEM extends SettleReceiptItem> {
    @Deprecated
    private String issuingBodyCode;
    private String belongSettlementUnit;
    private String agentCode;
    private String batchCode;
    protected List<ITEM> receiptItemList;

    @JsonIgnore
    public BigDecimal getTotalAmountSum() {
        if (CollectionUtils.isEmpty(this.receiptItemList)) {
            return BigDecimal.ZERO;
        }
        BigDecimal sum = this.receiptItemList.stream().map(SettleReceiptItem::getTotalAmount).reduce(BigDecimal.ZERO, (a, b) -> a.add((BigDecimal)b));
        return sum.setScale(3, RoundingMode.HALF_UP);
    }

    @Deprecated
    public ScmOrderSettleBaseDto<ITEM> setIssuingBodyCode(String issuingBodyCode) {
        this.issuingBodyCode = issuingBodyCode;
        return this;
    }

    public ScmOrderSettleBaseDto<ITEM> setBelongSettlementUnit(String belongSettlementUnit) {
        this.belongSettlementUnit = belongSettlementUnit;
        return this;
    }

    public ScmOrderSettleBaseDto<ITEM> setAgentCode(String agentCode) {
        this.agentCode = agentCode;
        return this;
    }

    public ScmOrderSettleBaseDto<ITEM> setBatchCode(String batchCode) {
        this.batchCode = batchCode;
        return this;
    }

    public ScmOrderSettleBaseDto<ITEM> setReceiptItemList(List<ITEM> receiptItemList) {
        this.receiptItemList = receiptItemList;
        return this;
    }

    @Deprecated
    public String getIssuingBodyCode() {
        return this.issuingBodyCode;
    }

    public String getBelongSettlementUnit() {
        return this.belongSettlementUnit;
    }

    public String getAgentCode() {
        return this.agentCode;
    }

    public String getBatchCode() {
        return this.batchCode;
    }

    public List<ITEM> getReceiptItemList() {
        return this.receiptItemList;
    }
}

