package com.rocogz.merchant.client.scm;


import com.rocogz.merchant.entity.scm.MerchantScmOrderDetail;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDate;

/**
 * 修复供应商套餐明细的 使用有效期
 *
 * @author zhangmin
 */
@Setter
@Getter
public class FixHistoryComboOrderDetailValidityDto {

    private Integer comboDetailId;

    /**
     * 上游订单使用有效期 生效日期
     * @see  MerchantScmOrderDetail#useValidityStartDate
     */
    private LocalDate useValidityStartDate;

    /**
     * 使用有效期设置时点：发放时设置，领取时设置
     * @see Constant.DictValiditySettingTimePoint#ISSUE
     */
    private String useValiditySetTimePoint;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 子订单编码
     */
    private String orderItemCode;

    /**
     * 套餐明细订单号
     */
    private String comboOrderItemCode;

    /**
     * 套餐明细产品编码,即套餐下包含的子商品的产品编号
     *
     * @see MerchantGoodsMeal#mealGoodsCode
     */
    private String productCode;


}
