package com.rocogz.merchant.entity.storeservice;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <p>
 * 商户服务项目订单数和平均分
 * </p>
 *
 * @author liangyongtong
 * @since 2020-05-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantStoreServiceKpi extends IdEntity {

    private static final long serialVersionUID = -1349317464819992658L;

    /**
     * 商户服务编码
     */
    private String storeServiceCode;

    /**
     * 专区编码
     */
    private String areaCode;

    /**
     * 商户编码
     */
    private String storeCode;

    /**
     * 专区服务项目编码
     */
    private String areaServiceCode;

    /**
     * 平均分
     */
    private BigDecimal score;

    /**
     * 商户服务项目订单数
     */
    private Integer orders;
}
