package com.rocogz.merchant.dto.customer.goods;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * <dl>
 * <dd>Description:保存主体可发放产品的仓库 </dd>
 * <dd>@date: 2022/03/17</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class BodyCustomerGoodsSaveWhReq {

    /**
     * 仓库编号
     */
    @NotBlank
    private String whCode;

    /**
     * 发放主体编码
     */
    @NotBlank
    private String issuingBodyCode;

    /**
     * 合作客户编号
     */
    @NotBlank
    private String customerCode;

    /**
     * 合作客户产品
     */
    @NotBlank
    private String customerGoodsCode;

    /**
     * 创建人
     */
    @NotBlank
    private String createUser;
}
