package com.rocogz.merchant.entity.store;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <p>
 * 标准礼包系统
 * </p>
 *
 * @author liangyongtong
 * @since 2020-12-30
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantStoreCoefficient extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 所属商户编码
     */
    private String storeCode;

    /**
     * 是否自行配置：Y 是 N 否
     */
    private String configure;

    /**
     * 系数
     */
    private BigDecimal coefficient;

}
