package com.rocogz.merchant.entity.storeservice;

import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 商户服务项目标签
 * </p>
 *
 * @author liangyongtong
 * @since 2020-05-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantStoreServiceLabel extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 标签名称
     */
    private String name;

    /**
     * 标签说明
     */
    private String introduce;

    /**
     * 标签状态: 启用 / 停用
     */
    private String status;


    /**
     * 标签图标
     */
    private String labelIcon;
}
