package com.rocogz.merchant.client.scm.intfc;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author yinshihao
 * @Description: 广东中石油发券返回dto
 * @Package com.rocogz.dto.dingju.response.token
 * @date 2021-04-09 13:25:54
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
@Data
@Accessors(chain = true)
public class DingjuOilGdzsyOrderRespDto {

    /**
     * 平台订单编号 (下单是否成功以此字段是否有值为准)
     */
    @JsonProperty("trade_no")
    private String tradeNo;

    /**
     * 商户订单号
     */
    @JsonProperty("out_order_id")
    private String outOrderId;

    /**
     * 扣款金额
     */
    @JsonProperty("pay_amount")
    private BigDecimal payAmount;

    /**
     * 券号
     */
    @JsonProperty("couponNo")
    private String couponNo;

    /**
     * 券名称
     */
    @JsonProperty("couponTitle")
    private String couponTitle;

    /**
     * 券金额
     */
    @JsonProperty("couponAmount")
    private BigDecimal couponAmount;

    /**
     * 生效时间
     */
    @JsonProperty("effectDate")
    private LocalDateTime effectDate;

    /**
     * 失效时间
     */
    @JsonProperty("expireDate")
    private LocalDateTime expireDate;

    /**
     * 订单状态
     * 1=>'待处理',
     * 2=>'已发券',
     * 3=>'发券失败',
     * 5=>'已退单',
     */
    @JsonProperty("state")
    private Integer state;

    /**
     * 券状态,0 待发券 1未使用 ，2已使用， 3已作废
     */
    @JsonProperty("couponStatus")
    private Integer couponStatus;
}
