package com.rocogz.merchant.entity.scm;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 主订单对应的交易类型关系
 * </p>
 *
 * @author yinshihao
 * @since 2021-04-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmOrderInformationTrade extends IdEntity {

    private static final long serialVersionUID = 8889598693176220791L;
    /**
     * 订单编码
     */
    private String orderCode;

    /**
     * 交易类型
     */
    private String tradeType;

    /**
     * 交易时间
     */
    private LocalDateTime tradeTime;
    
}
