package com.rocogz.merchant.client.scm.intfc;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author yinshihao
 * @Description: 重庆石化返回dto
 * @Package com.rocogz.dto.dingju.response.token
 * @date 2021-04-09 13:25:54
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
@Data
public class DingjuCqOilbizRspDto {

    /**
     * 平台订单编号 (下单是否成功以此字段是否有值为准)
     */
    @JsonProperty("trade_no")
    private String tradeNo;

    /**
     * 商品面值
     */
    @JsonProperty("item_face_price")
    private BigDecimal itemFacePrice;

    /**
     * 扣款金额
     */
    @JsonProperty("pay_amount")
    private BigDecimal payAmount;

    /**
     * 订单状态
     */
    @JsonProperty("state")
    private Integer state;

    /**
     * 重庆石化券码
     */
    @JsonProperty("couponCode")
    private String couponCode;
}
