package com.rocogz.merchant.dto.scm.order;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Set;

/**
 * 结算钩稽 结算结果消息
 *
 * @author zhangmin
 */
@Setter
@Getter
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ScmOrderSettleResultMsgDto extends ScmOrderSettleBaseDto<ReceiptItemSettleResult> {

    /**
     * 本次处理是否成功
     */
    private Boolean success;

    /**
     * 处理失败的原因
     */
    private String failReason;


    /**
     * 获取总的剩余余额合计
     *
     * @return
     */
    @JsonIgnore
    public BigDecimal getTotalBalance() {
        if (CollectionUtils.isEmpty(receiptItemList)) {
            return BigDecimal.ZERO;
        }

        BigDecimal sum = receiptItemList.stream().map(ReceiptItemSettleResult::getSurplusAmount).reduce(BigDecimal.ZERO, (a, b) -> a.add(b));
        return sum.setScale(3, RoundingMode.HALF_UP);
    }


    /**
     * 获取 总结算下游订单数量
     */
    public Integer getTotalSettledOrderNum() {
        if (CollectionUtils.isEmpty(receiptItemList)) {
            return 0;
        }

        Set<String> orderCodeSet = new HashSet<>();

        for (ReceiptItemSettleResult settleResultItem : receiptItemList) {
            if (!CollectionUtils.isEmpty(settleResultItem.getSettledOrderList())) {
                for (ReceiptItemSettleResult.SettledScmOrder scmOrder : settleResultItem.getSettledOrderList()) {
                    orderCodeSet.add(scmOrder.getOrderCode());
                }
            }
        }

        int totalOrderNum = orderCodeSet.size();
        return totalOrderNum;
    }

}
