package com.rocogz.merchant.dto.scmWarehouse.stock;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * <dl>
 * <dd>Description:冻结的商品 </dd>
 * <dd>@date: 2022/03/09</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class ScmGoodsStockFrozenItemDto {

    /**
     * 业务单号:
     * 可能的编号:清单编号
     */
    @NotBlank
    private String bizNo;
    /**
     * 数量
     */
    @Min(1)
    @NotNull
    private Integer qty;

    /**
     * 合作客户编号
     */
    @NotBlank
    private String customerGoodsCode;

    /**
     * 合作客户产品名称
     * 为了返回错误提示
     */
    @NotBlank
    private String customerGoodsName;

    /**
     * 服务商产品
     */
    @NotBlank
    private String agentGoodsCode;

    /**
     * 平台产品
     */
    @NotBlank
    private String platformGoodsCode;

    /**
     * 出库仓库编号,可以为空
     */
    private String whCode;





}
