package com.rocogz.merchant.dto.scmWarehouse.stock;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.Set;

/**
 * <dl>
 * <dd>Description:初始化请求</dd>
 * <dd>@date: 2022/03/11</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class ScmGoodsStockInitReq {

    /**
     * 仓库编号
     */
    @NotBlank
    private String whCode;

    /**
     * 放入仓库的产品编号
     */
    @NotEmpty
    private Set<String> goodsCodeList;

    /**
     * 操作账户编号
     */
    @NotBlank
    private String operator;

}
