package com.rocogz.merchant.entity.exchangeGoods;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 兑换商品修改操作日志
 * </p>
 *
 * @author yinshihao
 * @since 2020-08-14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantExchangeGoodsLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 兑换商品编码
     */
    private String goodsCode;

    /**
     * 操作项
     */
    private String logType;

    /**
     * 信息
     */
    private String logContent;

    /**
     * 操作人
     */
    private String logUser;

    /**
     * 操作时间
     */
    private LocalDateTime logTime;

    /**
     * 商品类型
     */
    private String goodsType;


}
