package com.rocogz.merchant.entity.scm;

import com.rocogz.merchant.constant.Constant;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 查询油卡面额，剩余金额 和使用状态
 *
 * @author zhangmin
 */
@Accessors(chain = true)
@Setter
@Getter
public class MerchantScmOrderDetailFetchAmount extends IdEntity {

    /**
     * 下游订单号
     */
    private String orderCode;

    /**
     * 上游订单号
     */
    private String orderItemCode;

    /**
     * 处理状态：待处理("PENDING"), 已处理("HANDLED")
     *
     * @see Constant.DictValidityExpiredHandleStatus#HANDLED
     */
    private String handleStatus;


    private LocalDateTime updateTime;

    /**
     * 余额
     */
    private BigDecimal balance;

    /**
     * 面额
     */
    private BigDecimal faceValue;

    /**
     * 过期余额
     */
    private BigDecimal expireBalance;

    /**
     * 使用状态：未使用，部分使用、已使用
     *
     * @see Constant.DictUseStatus
     */
    private String useStatus;


    /**
     * 返回字符串
     */
    private String resJson;

}
