package com.rocogz.merchant.entity.scm;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 订单日志操作流水
 * </p>
 *
 * @author yinshihao
 * @since 2021-03-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmOrderLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 变更类型
     */
    private String logType;

    /**
     * 操作说明
     */
    private String remark;

    /**
     * 操作前状态
     */
    private String beforeStatus;

    /**
     * 操作后状态
     */
    private String afterStatus;

    /**
     * 操作人名字
     */
    private String logUser;

    /**
     * 操作时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime logTime;

    /**
     * 操作结果(成功或失败)
     */
    private String operationStatus;

    /**
     * 日志订单类型: DOWN 下游订单 UP 上游订单
     */
    private String orderType;
}
