package com.rocogz.merchant.entity.store;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 商户关联的标签
 * </p>
 *
 * @author yinshihao
 * @since 2021-10-27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantStoreAreaLabel extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 商户编码
     */
    private String storeCode;

    /**
     * 专区编号
     */
    private String areaCode;

    /**
     * 专区名称
     */
    private String areaName;

    /**
     * 专区所属小程序miniAppId
     */
    private String miniAppid;

    /**
     * 专区所属小程序miniAppName
     */
    @TableField(exist = false)
    private String miniAppName;

    /**
     * 标签编码
     */
    private String labelCode;

    /**
     * 标签内容
     */
    private String labelContent;

    /**
     * 标签编码列表
     */
    @TableField(exist = false)
    private String labelCodeList;

    /**
     * 标签内容列表
     */
    @TableField(exist = false)
    private String labelContentList;


}
