package com.rocogz.merchant.request.agent.goods;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.Digits;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 代理商产品保存请求类
 * </p>
 *
 * @author djt
 * @since 2020-12-16
 */
@Data
public class MerchantAgentGoodsSaveReq implements Serializable {

    /**
     * 代理商产品编号
     */
    private String code;

    /**
     * 代理商产品名称
     */
    @NotBlank
    private String name;

    /**
     * 平台产品编号(merchant_goods.code)
     */
    @NotBlank(message = "平台产品编号不能为空")
    private String merchantGoodsCode;

    /**
     * 代理商编号(merchant_agent.code)
     */
    @NotBlank(message = "代理商编号不能为空")
    private String agentCode;

    /**
     * 代理商采购价
     */
    @Digits(integer=12,fraction = 3, message = "[额度扣减单价]请输入大于0的数字，最多3位小数")
    private BigDecimal purchasePrice;

    /**
     * 采购结算单价
     */
    @Digits(integer=12,fraction = 3, message = "[采购结算单价]请输入大于等于0的数字，最多3位小数")
    private BigDecimal purchaseSettlePrice;

    /**
     * 代理商市场价
     */
    @Digits(integer=12,fraction = 3, message = "[代理商市场价/面额]请输入大于0的数字，最多3位小数")
    @NotNull(message = "市场价不能为空")
    private BigDecimal marketPrice;

    /**
     * 代理商产品说明
     */
    private String introduce;

    /**
     * 上下架状态
     */
    @NotBlank(message = "上下架状态不能为空")
    private String status;


    /**
     * 创建人id
     */
    @NotNull
    private Integer createUser;

    /**
     * 创建人名称
     */
    @NotBlank
    private String createUserName;


    /**
     * 更新人id
     */
    @NotNull
    private Integer updateUser;

    /**
     * 更新人名称
     */
    @NotBlank
    private String updateUserName;

    /**
     * 采购方式
     */
    private String purchaseWay;

    /**
     * 建议兑换积分值
     */
    @Digits(integer=12,fraction = 3, message = "[建议兑换积分值]请输入大于0的数字，最多3位小数")
    private BigDecimal suggestExchangePointValue;

    /**
     * 服务商备付金扣减时点
     */
    @NotBlank
    private String deductionTime;

    /**
     * 备注
     */
    private String remark;
}
