package com.rocogz.merchant.dto.scmWarehouse.stock.pointExchange;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * <dl>
 * <dd>Description:冻结的商品 </dd>
 * <dd>@date: 2022/03/09</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class ScmPointExchangeGoodsStockFrozenItemDto {

    /**
     * 业务单号:
     * 可能的编号:清单/订单
     */
    @NotBlank
    private String bizNo;
    /**
     * 数量
     */
    @Min(1)
    @NotNull
    private Integer qty;

    //冻结时依据  whCode 对应仓库类型，扣减agentGoodsCode/platformGoodsCode的产品库存
    /**
     * 服务商产品
     */
    @NotBlank
    private String agentGoodsCode;

    /**
     * 平台产品
     */
    @NotBlank
    private String platformGoodsCode;

    /**
     * 积分兑换产品编号
     */
    @NotBlank
    private String exchangePointGoodsCode;

    /**
     * 积分兑换产品的名称
     * 场景：当whCode没有传递时，返回【exchangePointGoodsName】请配置出库仓库
     * 场景：当库存不足时 Response.failureWithData("库存不足", viewDto.getExchangePointGoodsCode());
     * 返回的data数据不为空时，请处理
     */
    @NotBlank
    private String exchangePointGoodsName;

    /**
     * 出库仓库编号,可以为空,但传递到冻结库存时，校验为空则会返回错误
     */
    private String whCode;





}
