package com.rocogz.merchant.entity.combo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.merchant.entity.gears.MerchantComboGears;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 套餐管理
 * </p>
 *
 * @author yifenrui
 * @since 2020-12-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("merchant_combo")
public class MerchantCombo extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 类型：商户套餐、天安套餐
     */
    private String type;

    /**
     * 套餐编码
     */
    private String code;

    /**
     * 关联的商户编码、档位编码
     */
    private String relateCode;

    /**
     * 名称
     */
    private String name;

    /**
     * 介绍说明
     */
    private String instructions;

    /**
     * 排序值
     */
    private Integer sort;

    /**
     * 列表图片
     */
    private String listImage;

    /**
     * 详情图片
     */
    private String detailImage;

    /**
     * 显示价格
     */
    private BigDecimal showPrice;

    /**
     * 市场价总和
     */
    private BigDecimal marketPrice;

    /**
     * 成本价总和
     */
    private BigDecimal costPrice;

    /**
     * 套餐总数量
     */
    private Integer count;

    /**
     * 状态：上架、未上架
     */
    private String status;

    /**
     * 创建来源
     */
    private String source;

    @TableField(exist = false)
    private List<MerchantComboDetail> merchantComboDetailList;

    /**
     * 删除前的优惠券--用于日志记录
     */
    @TableField(exist = false)
    private List<MerchantComboDetail> beforeMerchantComboDetailList;

    @TableField(exist = false)
    private String storeName;

    @TableField(exist = false)
    private MerchantComboGears merchantComboGears;
}
