package com.rocogz.merchant.dto.inverst;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.merchant.entity.inverst.MerchantInverstConfigQuestion;
import com.rocogz.merchant.enumerate.InverstQuestTypeEnum;
import com.rocogz.merchant.enumerate.InvestRateTypeEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author zhangmin
 * 提交的考券的 题目
 */
@Setter
@Getter
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantExamQuestDto {

    /**
     * 问题编号
     */
    private String questCode;

    /**
     * 问题题型
     */
    private InverstQuestTypeEnum questType;

    /**
     * 问题题干
     */
    private String questTitle;

    /**
     * 题目顺序号
     */
    private Integer questSeq;

    /**
     * 是否必答题
     */
    private Boolean mustAnswer;

    /**
     * 题目评分：NPS评分最小值 【评分类型题目 专有字段】
     */
    private Integer rateMin;

    /**
     *  题目评分：NPS评分最大值 【评分类型题目 专有字段】
     */
    private Integer rateMax;


    /**
     * 评分题：用户选择的答案：评分
     */
    private Integer selectedRate;

    /**
     * 只有配置了 评分便签问题,并且用户选择了评分数，才知道 本次评分结果类型
     * 本次评分结果类型：算正面评分，还是负面评分
     * @see MerchantInverstConfigQuestion#rateConfigure
     */
    private InvestRateTypeEnum rateResultType;

    /**
     * 问答题：用户回答的答案
     */
    private String answer;


    private List<MerchantExamQuestOptionDto> optionList;

}
