package com.rocogz.merchant.entity.inverst;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;


/**
 * <p>
 * 调查问券基本配置信息
 * </p>
 *
 * @author zhangmin
 * @since 2023-01-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class MerchantInverstConfig extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 问券编号
     */
    private String inverstCode;

    /**
     * 问券主题
     */
    private String topic;

    /**
     * 发放主体编号
     */
    private String issueBodyCode;

    /**
     * 问卷说明
     */
    private String instruction;

    /**
     * 问卷头部banner图
     */
    private String bannerUrl;

    /**
     * 小程序码图片地址，小程序菊花码图片url
     */
    private String qrCodeUrl;

    /**
     * 小程序二维码 编号
     * @see com.rocogz.syy.operation.entity.qr.OperateQr#code
     */
    private String miniAppQrCode;

    /**
     * 小程序的跳转path，例如：packageE/pages/questionnaire/index?inverstCode=WJ2020061300001
     */
    private String miniAppPath;

    /**
     * 跳转路径 对应的编号，例如：WF9Q
     * @see com.rocogz.syy.operation.entity.qr.OperateQrParameter#code
     */
    private String jumpCode;

    /**
     * 当前答券人数
     */
    private Integer joinPersonNum;

    /**
     * 总答券次数
     */
    private Integer joinNum;

    /**
     * 问券上下架状态
     * @see Constant.DictInverstStatus
     */
    private String status;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;


    //=== 下面是非持久化字段

    @TableField(exist = false)
    private List<MerchantInverstConfigQuestion> questionList;

    //发放主体简称
    @TableField(exist = false)
    private String issueBodyAbbreviation;

    //小程序ID
    @TableField(exist = false)
    private String minAppId;

    @TableField(exist = false)
    private String miniAppName;

}
