package com.rocogz.merchant.dto.scmWarehouse.inside;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;

/**
 * <dl>
 * <dd>Description:要操作的仓库映射DTO</dd>
 * <dd>@date: 2022/03/09</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class MerchantScmBodyGoodsWarehouseMappingDto {

    /**
     * 业务单号
     * 1.清单编号
     */
    private String bizNo;
    /**
     * 主体code
     */
    private String issuingBodyCode;
    /**
     * 主体的合作客户产品编号
     */
    private String customerGoodsCode;
    /**
     * 服务商产品
     */
    private String agentGoodsCode;
    /**
     * 平台产品
     */
    private String platformGoodsCode;

    /**
     * 积分兑换产品编号
     */
    private String exchangePointGoodsCode;

    /**
     * 出库的仓库编号 将实际的出库产品根据仓库类型，保存在whGoodsCode 中
     */
    private String whCode;
    /**
     * 出库的仓库商品编号
     */
    private String whGoodsCode;
    /**
     * 要进行冻结的数据
     */
    private Integer qty;

    //版本，为了保证数据 biz+stage+version 是唯一
    //因重复冻结引入
    private Integer version;

}
