package com.rocogz.merchant.dto.scmWarehouse.stock;

import com.rocogz.merchant.constant.ScmWarehouseConstant;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:SMC商品的库存调整请求：请加/减少/预警库存调整 </dd>
 * <dd>@date: 2022/03/09</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class ScmGoodsStockAdjustReq {
    /**
     * 仓库编码
     */
    @NotBlank
    private String whCode;
    /**
     * 产品编码
     */
    @NotBlank
    private String goodsCode;
    /**
     * 调整数量增加/减少/预警直接调整数量
     */
    @Min(0)
    @NotNull
    private Integer adjustQty;
    /**
     * 操作项
     * @see ScmWarehouseConstant.DictScmStockAdjustType#TYPE_CODE
     */
    @NotBlank
    private String  operateType;

    /**
     * 操作人
     */
    @NotBlank
    private String operator;
    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
    /**
     * 备注
     */
    private String remark ;
}
