package com.rocogz.merchant.client.scm.intfc;

import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @author zhangjunkui
 * @Description: 南网电动充值余额 所用
 * @date 2023-3-1 10:08:04
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
@Data
@Accessors(chain = true)
public class SouthernPowerGridReqDto extends BaseConfigReqDto {

    /**
     * 商户订单号
     */
    private String merchantOrderNo;

    /**
     * 金额
     */
    private BigDecimal amount;

    /**
     * 三方产品编号
     */
    private String goodsCode;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 流水号
     */
    private String serialNo;

    /**
     * 卡号
     */
    private String cardNo;

    /**
     * 优惠券编码
     */
    private String cpnNo;

    /**
     * 扩展信息，json格式
     */
    private String ext;

    /**
     * 下单结果 回调接口
     */
    private String callbackUrl;

    /**
     * 退款结果 回调接口
     */
    private String refundCallbackUrl;

    /**
     * 创建人
     */
    private String createUser;

}