package com.rocogz.merchant.dto.scmWarehouse.stock;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * <dl>
 * <dd>Description:解冻的商品 </dd>
 * <dd>@date: 2022/03/09</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class ScmGoodsStockUnFrozenItemDto {


    /**
     * 业务单号:
     * 可能的编号:清单编号
     */
    @NotBlank
    private String bizNo;


    /**
     * 解冻的产品编号
     */
    @NotBlank
    private String goodsCode;

    /**
     * 解冻的数量
     */
    @Min(1)
    @NotNull
    private Integer qty;

    /**
     * 错误信息
     */
    private String errorInfo;


}
