package com.rocogz.merchant.client.scm.intfc;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * @author 尹世豪
 * @Description:
 * @Package com.rocogz.dto.dingju.response.token
 * @date 2020/11/16 8:54
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
@Data
@Accessors(chain = true)
public class DingjuGrantPowerReqDto extends BaseConfigReqDto {

    /**
     * 权益编号
     */
    @NotNull(message = "权益编号不可为空")
    private Integer powerId;

    /**
     * 发放手机号
     */
    @NotEmpty(message = "发放手机号不可为空")
    private String phone;

    /**
     * 绑定车牌
     */
    private String plateNumber;

    /**
     * 商户订单号
     */
    @NotEmpty(message = "商户订单号不可为空")
    private String outOrderId;

    /**
     * 回调URL
     */
    private String notifyUrl;
}
